/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.ManyToOne;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.ToOne;

public abstract class MappingFactory<R extends Entity, T extends Property> {
    public static final String IDENTITY_PROPERTY = "id";
    public static final Set<String> SIMPLE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Boolean.TYPE.getName(), Long.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Byte.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Character.TYPE.getName(), Boolean.class.getName(), Long.class.getName(), Short.class.getName(), Integer.class.getName(), Byte.class.getName(), Float.class.getName(), Double.class.getName(), Character.class.getName(), String.class.getName(), java.util.Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), Date.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), Locale.class.getName(), Calendar.class.getName(), GregorianCalendar.class.getName(), Currency.class.getName(), TimeZone.class.getName(), Object.class.getName(), Class.class.getName(), byte[].class.getName(), Byte[].class.getName(), char[].class.getName(), Character[].class.getName(), Blob.class.getName(), Clob.class.getName(), Serializable.class.getName(), URI.class.getName(), URL.class.getName(), "org.bson.types.ObjectId")));
    private static Map<Class, CustomTypeMarshaller> typeConverterMap = new ConcurrentHashMap<Class, CustomTypeMarshaller>();

    public static void registerCustomType(CustomTypeMarshaller marshallerCustom) {
        typeConverterMap.put(marshallerCustom.getTargetType(), marshallerCustom);
    }

    public boolean isSimpleType(Class propType) {
        if (propType == null) {
            return false;
        }
        if (propType.isEnum()) {
            return !MappingFactory.isCustomType(propType);
        }
        if (propType.isArray()) {
            return this.isSimpleType(propType.getComponentType());
        }
        String typeName = propType.getName();
        return MappingFactory.isSimpleType(typeName);
    }

    public static boolean isSimpleType(String typeName) {
        return SIMPLE_TYPES.contains(typeName);
    }

    public abstract R createMappedForm(PersistentEntity var1);

    public abstract T createMappedForm(PersistentProperty var1);

    public Identity<T> createIdentity(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
        return new Identity<T>(owner, context, pd){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping<T> getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public Custom<T> createCustom(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
        CustomTypeMarshaller customTypeMarshaller = typeConverterMap.get(pd.getPropertyType());
        if (customTypeMarshaller == null && pd.getPropertyType().isEnum()) {
            customTypeMarshaller = typeConverterMap.get(Enum.class);
        }
        if (customTypeMarshaller == null) {
            throw new IllegalStateException("Cannot create a custom type without a type converter for type " + pd.getPropertyType());
        }
        return new Custom<T>(owner, context, pd, customTypeMarshaller){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping<T> getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public Simple<T> createSimple(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
        return new Simple<T>(owner, context, pd){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            @Override
            public PropertyMapping<T> getMapping() {
                return this.propertyMapping;
            }
        };
    }

    protected PropertyMapping<T> createPropertyMapping(final PersistentProperty<T> property, final PersistentEntity owner) {
        return new PropertyMapping<T>(){
            private T mappedForm;
            {
                this.mappedForm = MappingFactory.this.createMappedForm(property);
            }

            @Override
            public ClassMapping getClassMapping() {
                return owner.getMapping();
            }

            @Override
            public T getMappedForm() {
                return this.mappedForm;
            }
        };
    }

    public ToOne createOneToOne(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new OneToOne<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public ToOne createManyToOne(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new ManyToOne<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public OneToMany createOneToMany(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new OneToMany<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public ManyToMany createManyToMany(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new ManyToMany<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public Embedded createEmbedded(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new Embedded<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public EmbeddedCollection createEmbeddedCollection(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return new EmbeddedCollection<T>(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }
        };
    }

    public Basic createBasicCollection(PersistentEntity entity, MappingContext context, PropertyDescriptor property, Class collectionType) {
        Basic basic = new Basic(entity, context, property){
            PropertyMapping<T> propertyMapping;
            {
                this.propertyMapping = MappingFactory.this.createPropertyMapping(this, this.owner);
            }

            public PropertyMapping getMapping() {
                return this.propertyMapping;
            }
        };
        CustomTypeMarshaller customTypeMarshaller = typeConverterMap.get(property.getPropertyType());
        if (collectionType != null && collectionType.isEnum() && (customTypeMarshaller = typeConverterMap.get(collectionType)) == null) {
            customTypeMarshaller = typeConverterMap.get(Enum.class);
        }
        if (customTypeMarshaller != null) {
            basic.setCustomTypeMarshaller(customTypeMarshaller);
        }
        return basic;
    }

    public Basic createBasicCollection(PersistentEntity entity, MappingContext context, PropertyDescriptor property) {
        return this.createBasicCollection(entity, context, property, null);
    }

    public static boolean isCustomType(Class<?> propertyType) {
        if (typeConverterMap.containsKey(propertyType)) {
            return true;
        }
        if (propertyType.isEnum()) {
            return typeConverterMap.containsKey(Enum.class);
        }
        return false;
    }

    public IdentityMapping createIdentityMapping(ClassMapping classMapping) {
        return this.createDefaultIdentityMapping(classMapping);
    }

    public IdentityMapping createDefaultIdentityMapping(final ClassMapping classMapping) {
        return new IdentityMapping(){

            @Override
            public String[] getIdentifierName() {
                return new String[]{MappingFactory.IDENTITY_PROPERTY};
            }

            @Override
            public ClassMapping getClassMapping() {
                return classMapping;
            }

            public Property getMappedForm() {
                return null;
            }
        };
    }
}

