/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.proxy;

import groovy.lang.GroovyObject;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.proxy.EntityProxy;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.proxy.SessionEntityProxyMethodHandler;
import org.grails.datastore.mapping.reflect.ReflectionUtils;

public class JavassistProxyFactory
implements ProxyFactory {
    private static final Map<Class, Class> PROXY_FACTORIES = new ConcurrentHashMap<Class, Class>();
    private static final Map<Class, Class> ID_TYPES = new ConcurrentHashMap<Class, Class>();
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set<String> EXCLUDES = new HashSet<String>(Arrays.asList("$getStaticMetaClass"));

    @Override
    public boolean isProxy(Object object) {
        return object instanceof EntityProxy;
    }

    @Override
    public Serializable getIdentifier(Object obj) {
        return ((EntityProxy)obj).getProxyKey();
    }

    @Override
    public boolean isInitialized(Object object) {
        return !this.isProxy(object) || ((EntityProxy)object).isInitialized();
    }

    @Override
    public Object unwrap(Object object) {
        if (this.isProxy(object)) {
            return ((EntityProxy)object).getTarget();
        }
        return object;
    }

    @Override
    public <T> T createProxy(Session session, Class<T> type, Serializable key) {
        return (T)this.getProxyInstance(session, type, key);
    }

    protected Object createProxiedInstance(Session session, Class cls, Class proxyClass, Serializable id) {
        MethodHandler mi = this.createMethodHandler(session, cls, proxyClass, id);
        Object proxy = ReflectionUtils.instantiate(proxyClass);
        ((ProxyObject)proxy).setHandler(mi);
        return proxy;
    }

    protected MethodHandler createMethodHandler(Session session, Class cls, Class proxyClass, Serializable id) {
        return new SessionEntityProxyMethodHandler(proxyClass, session, cls, id);
    }

    protected Serializable convertId(Serializable idAsInput, Class<?> ownerClass) {
        if (idAsInput == null) {
            return null;
        }
        Class idType = ID_TYPES.get(ownerClass);
        if (idType != null) {
            if (idType.isInstance(idAsInput)) {
                return idAsInput;
            }
            if (idType == String.class) {
                return idAsInput.toString();
            }
            if (Number.class.isAssignableFrom(idType) && idAsInput instanceof Number) {
                Number idNumber = (Number)idAsInput;
                if (idType == Integer.class) {
                    return Integer.valueOf(idNumber.intValue());
                }
                if (idType == Long.class) {
                    return Long.valueOf(idNumber.longValue());
                }
            }
            if (idType == Integer.class) {
                return Integer.valueOf(Integer.parseInt(idAsInput.toString()));
            }
            if (idType == Long.class) {
                return Long.valueOf(Long.parseLong(idAsInput.toString()));
            }
            return (Serializable)idType.cast(idAsInput);
        }
        return idAsInput;
    }

    protected Object getProxyInstance(Session session, Class type, Serializable idAsInput) {
        Class proxyClass = this.getProxyClass(type);
        Serializable id = this.convertId(idAsInput, type);
        return this.createProxiedInstance(session, type, proxyClass, id);
    }

    protected Class getProxyClass(Class type) {
        Class proxyClass = PROXY_FACTORIES.get(type);
        if (proxyClass == null) {
            javassist.util.proxy.ProxyFactory pf = new javassist.util.proxy.ProxyFactory();
            pf.setSuperclass(type);
            pf.setInterfaces(new Class[]{EntityProxy.class, GroovyObject.class});
            pf.setFilter(new MethodFilter(){

                public boolean isHandled(Method method) {
                    String methodName = method.getName();
                    if (methodName.indexOf("super$") > -1) {
                        return false;
                    }
                    if (method.getParameterTypes().length == 0 && methodName.equals("finalize")) {
                        return false;
                    }
                    return !EXCLUDES.contains(methodName) && !method.isSynthetic() && !method.isBridge();
                }
            });
            proxyClass = pf.createClass();
            PROXY_FACTORIES.put(type, proxyClass);
            Method getIdMethod = org.springframework.util.ReflectionUtils.findMethod((Class)type, (String)"getId", (Class[])EMPTY_CLASS_ARRAY);
            Class<?> idType = getIdMethod.getReturnType();
            if (idType != null) {
                ID_TYPES.put(type, idType);
            }
        }
        return proxyClass;
    }
}

