/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.reflect;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.grails.datastore.mapping.reflect.ReflectionUtils;

public class ClassPropertyFetcher {
    private final Class clazz;
    final Map<String, List<PropertyFetcher>> staticFetchers = new HashMap<String, List<PropertyFetcher>>();
    final Map<String, PropertyFetcher> instanceFetchers = new HashMap<String, PropertyFetcher>();
    private final ReferenceInstanceCallback callback;
    private PropertyDescriptor[] propertyDescriptors;
    private Map<String, PropertyDescriptor> propertyDescriptorsByName = new HashMap<String, PropertyDescriptor>();
    private Map<String, Field> fieldsByName = new HashMap<String, Field>();
    private Map<Class, List<PropertyDescriptor>> typeToPropertyMap = new HashMap<Class, List<PropertyDescriptor>>();
    private static Map<Class, ClassPropertyFetcher> cachedClassPropertyFetchers = new WeakHashMap<Class, ClassPropertyFetcher>();

    public static ClassPropertyFetcher forClass(Class c) {
        ClassPropertyFetcher cpf = cachedClassPropertyFetchers.get(c);
        if (cpf == null) {
            cpf = new ClassPropertyFetcher(c);
            cachedClassPropertyFetchers.put(c, cpf);
        }
        return cpf;
    }

    public static void clearCache() {
        cachedClassPropertyFetchers.clear();
    }

    ClassPropertyFetcher(final Class clazz) {
        this.clazz = clazz;
        this.callback = new ReferenceInstanceCallback(){

            @Override
            public Object getReferenceInstance() {
                return ReflectionUtils.instantiate(clazz);
            }
        };
        this.init();
    }

    public Class getJavaClass() {
        return this.clazz;
    }

    public Object getReference() {
        return this.callback == null ? null : this.callback.getReferenceInstance();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public boolean isReadableProperty(String name) {
        return this.staticFetchers.containsKey(name) || this.instanceFetchers.containsKey(name);
    }

    private void init() {
        List<Class> allClasses = this.resolveAllClasses(this.clazz);
        for (Class c : allClasses) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                this.processField(field);
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                this.processMethod(method);
            }
        }
        try {
            this.propertyDescriptors = Introspector.getBeanInfo(this.clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        if (this.propertyDescriptors == null) {
            return;
        }
        for (PropertyDescriptor desc : this.propertyDescriptors) {
            this.propertyDescriptorsByName.put(desc.getName(), desc);
            Class<?> propertyType = desc.getPropertyType();
            if (propertyType == null) continue;
            List<PropertyDescriptor> pds = this.typeToPropertyMap.get(propertyType);
            if (pds == null) {
                pds = new ArrayList<PropertyDescriptor>();
                this.typeToPropertyMap.put(propertyType, pds);
            }
            pds.add(desc);
            Method readMethod = desc.getReadMethod();
            if (readMethod == null) continue;
            boolean staticReadMethod = Modifier.isStatic(readMethod.getModifiers());
            if (staticReadMethod) {
                List<PropertyFetcher> propertyFetchers = this.staticFetchers.get(desc.getName());
                if (propertyFetchers == null) {
                    propertyFetchers = new ArrayList<PropertyFetcher>();
                    this.staticFetchers.put(desc.getName(), propertyFetchers);
                }
                propertyFetchers.add(new GetterPropertyFetcher(readMethod, true));
                continue;
            }
            this.instanceFetchers.put(desc.getName(), new GetterPropertyFetcher(readMethod, false));
        }
    }

    private void processMethod(Method method) {
        String name;
        if (method.isSynthetic()) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return;
        }
        if (Modifier.isStatic(method.getModifiers()) && method.getReturnType() != Void.class && method.getParameterTypes().length == 0 && (name = method.getName()).indexOf(36) == -1) {
            if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3))) {
                name = name.substring(3);
            } else if (name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2)) && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                name = name.substring(2);
            }
            GetterPropertyFetcher fetcher = new GetterPropertyFetcher(method, true);
            List<PropertyFetcher> propertyFetchers = this.staticFetchers.get(name);
            if (propertyFetchers == null) {
                propertyFetchers = new ArrayList<PropertyFetcher>();
                this.staticFetchers.put(name, propertyFetchers);
            }
            propertyFetchers.add(fetcher);
            String decapitalized = Introspector.decapitalize(name);
            if (!decapitalized.equals(name)) {
                propertyFetchers = this.staticFetchers.get(decapitalized);
                if (propertyFetchers == null) {
                    propertyFetchers = new ArrayList<PropertyFetcher>();
                    this.staticFetchers.put(decapitalized, propertyFetchers);
                }
                propertyFetchers.add(fetcher);
            }
        }
    }

    private void processField(Field field) {
        if (field.isSynthetic()) {
            return;
        }
        int modifiers = field.getModifiers();
        String name = field.getName();
        if (!Modifier.isPublic(modifiers)) {
            if (name.indexOf(36) == -1) {
                this.fieldsByName.put(name, field);
            }
        } else if (name.indexOf(36) == -1) {
            boolean staticField = Modifier.isStatic(modifiers);
            if (staticField) {
                List<PropertyFetcher> propertyFetchers = this.staticFetchers.get(name);
                if (propertyFetchers == null) {
                    propertyFetchers = new ArrayList<PropertyFetcher>();
                    this.staticFetchers.put(name, propertyFetchers);
                }
                propertyFetchers.add(new FieldReaderFetcher(field, staticField));
            } else {
                this.instanceFetchers.put(name, new FieldReaderFetcher(field, staticField));
            }
        }
    }

    private List<Class> resolveAllClasses(Class c) {
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class currentClass = c; currentClass != null; currentClass = currentClass.getSuperclass()) {
            list.add(currentClass);
        }
        Collections.reverse(list);
        return list;
    }

    public Object getPropertyValue(String name) {
        return this.getPropertyValue(name, false);
    }

    public Object getPropertyValue(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        return this.getPropertyValueWithFetcher(name, fetcher);
    }

    public Object getPropertyValue(final Object instance, String name) {
        PropertyFetcher fetcher = this.resolveFetcher(name, true);
        return this.getPropertyValueWithFetcher(name, fetcher, new ReferenceInstanceCallback(){

            @Override
            public Object getReferenceInstance() {
                return instance;
            }
        });
    }

    private Object getPropertyValueWithFetcher(String name, PropertyFetcher fetcher) {
        ReferenceInstanceCallback thisCallback = this.callback;
        return this.getPropertyValueWithFetcher(name, fetcher, thisCallback);
    }

    private Object getPropertyValueWithFetcher(String name, PropertyFetcher fetcher, ReferenceInstanceCallback thisCallback) {
        if (fetcher != null) {
            try {
                return fetcher.get(thisCallback);
            }
            catch (Exception e) {
                System.err.println("Error fetching property's " + name + " value from class " + this.clazz.getName() + ": " + e.getMessage());
            }
        }
        return null;
    }

    public <T> T getStaticPropertyValue(String name, Class<T> c) {
        List<PropertyFetcher> propertyFetchers = this.staticFetchers.get(name);
        if (propertyFetchers == null) {
            return null;
        }
        PropertyFetcher fetcher = propertyFetchers.get(0);
        Object v = this.getPropertyValueWithFetcher(name, fetcher);
        return this.returnOnlyIfInstanceOf(v, c);
    }

    public <T> List<T> getStaticPropertyValuesFromInheritanceHierarchy(String name, Class<T> c) {
        List<PropertyFetcher> propertyFetchers = this.staticFetchers.get(name);
        if (propertyFetchers == null) {
            return Collections.emptyList();
        }
        ArrayList<T> values = new ArrayList<T>(propertyFetchers.size());
        for (PropertyFetcher fetcher : propertyFetchers) {
            Object v = this.getPropertyValueWithFetcher(name, fetcher);
            T t = this.returnOnlyIfInstanceOf(v, c);
            if (t == null) continue;
            values.add(t);
        }
        return values;
    }

    public <T> T getPropertyValue(String name, Class<T> c) {
        return this.returnOnlyIfInstanceOf(this.getPropertyValue(name, false), c);
    }

    private <T> T returnOnlyIfInstanceOf(Object value, Class<T> type) {
        if (value != null && (type == Object.class || ReflectionUtils.isAssignableFrom(type, value.getClass()))) {
            return (T)value;
        }
        return null;
    }

    private PropertyFetcher resolveFetcher(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = null;
        if (!onlyInstanceProperties) {
            List<PropertyFetcher> f = this.staticFetchers.get(name);
            PropertyFetcher propertyFetcher = fetcher = f == null ? null : f.get(0);
        }
        if (fetcher == null) {
            fetcher = this.instanceFetchers.get(name);
        }
        return fetcher;
    }

    public Class getPropertyType(String name) {
        return this.getPropertyType(name, false);
    }

    public Class getPropertyType(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        return fetcher == null ? null : fetcher.getPropertyType(name);
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.propertyDescriptorsByName.get(name);
    }

    public List<PropertyDescriptor> getPropertiesOfType(Class javaClass) {
        List<PropertyDescriptor> propertyDescriptorList = this.typeToPropertyMap.get(javaClass);
        if (propertyDescriptorList == null) {
            return Collections.emptyList();
        }
        return propertyDescriptorList;
    }

    public List<PropertyDescriptor> getPropertiesAssignableToType(Class assignableType) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        for (Class type : this.typeToPropertyMap.keySet()) {
            if (!assignableType.isAssignableFrom(type)) continue;
            properties.addAll((Collection<PropertyDescriptor>)this.typeToPropertyMap.get(type));
        }
        return properties;
    }

    public List<PropertyDescriptor> getPropertiesAssignableFromType(Class assignableType) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        for (Class type : this.typeToPropertyMap.keySet()) {
            if (!type.isAssignableFrom(assignableType)) continue;
            properties.addAll((Collection<PropertyDescriptor>)this.typeToPropertyMap.get(type));
        }
        return properties;
    }

    public Field getDeclaredField(String name) {
        return this.fieldsByName.get(name);
    }

    static class FieldReaderFetcher
    implements PropertyFetcher {
        private final Field field;
        private final boolean staticField;

        public FieldReaderFetcher(Field field, boolean staticField) {
            this.field = field;
            this.staticField = staticField;
            ReflectionUtils.makeAccessible(field);
        }

        @Override
        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticField) {
                return this.field.get(null);
            }
            if (callback != null) {
                return this.field.get(callback.getReferenceInstance());
            }
            return null;
        }

        @Override
        public Class getPropertyType(String name) {
            return this.field.getType();
        }
    }

    static class GetterPropertyFetcher
    implements PropertyFetcher {
        private final Method readMethod;
        private final boolean staticMethod;

        GetterPropertyFetcher(Method readMethod, boolean staticMethod) {
            this.readMethod = readMethod;
            this.staticMethod = staticMethod;
            ReflectionUtils.makeAccessible(readMethod);
        }

        @Override
        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticMethod) {
                return this.readMethod.invoke(null, (Object[])null);
            }
            if (callback != null) {
                return this.readMethod.invoke(callback.getReferenceInstance(), (Object[])null);
            }
            return null;
        }

        @Override
        public Class getPropertyType(String name) {
            return this.readMethod.getReturnType();
        }
    }

    static interface PropertyFetcher {
        public Object get(ReferenceInstanceCallback var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public Class getPropertyType(String var1);
    }

    public static interface ReferenceInstanceCallback {
        public Object getReferenceInstance();
    }
}

