/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.transactions;

import javax.persistence.FlushModeType;
import org.grails.datastore.mapping.core.ConnectionNotFoundException;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.grails.datastore.mapping.transactions.Transaction;
import org.grails.datastore.mapping.transactions.TransactionObject;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class DatastoreTransactionManager
extends AbstractPlatformTransactionManager {
    private Datastore datastore;
    private boolean datastoreManagedSession;

    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }

    public Datastore getDatastore() {
        Assert.notNull((Object)this.datastore, (String)"Cannot use DatastoreTransactionManager without a datastore set!");
        return this.datastore;
    }

    public void setDatastoreManagedSession(boolean datastoreManagedSession) {
        this.datastoreManagedSession = datastoreManagedSession;
    }

    protected Object doGetTransaction() throws TransactionException {
        TransactionObject txObject = new TransactionObject();
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getDatastore()));
        if (sessionHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound Session [" + sessionHolder.getSession() + "] for Datastore transaction"));
            }
            txObject.setSessionHolder(sessionHolder);
        } else if (this.datastoreManagedSession) {
            try {
                Session session = this.getDatastore().getCurrentSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found Datastore-managed Session [" + session + "] for Spring-managed transaction"));
                }
                txObject.setExistingSession(session);
            }
            catch (ConnectionNotFoundException ex) {
                throw new DataAccessResourceFailureException("Could not obtain Datastore-managed Session for Spring-managed transaction", (Throwable)ex);
            }
        } else {
            Session session = this.getDatastore().connect();
            txObject.setSession(session);
        }
        return txObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBegin(Object o, TransactionDefinition definition) throws TransactionException {
        TransactionObject txObject = (TransactionObject)o;
        Session session = null;
        try {
            session = txObject.getSessionHolder().getSession();
            if (definition.isReadOnly()) {
                session.setFlushMode(FlushModeType.COMMIT);
            }
            Transaction tx = session.beginTransaction();
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                tx.setTimeout(timeout);
            }
            txObject.setTransaction(tx);
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getDatastore(), (Object)((Object)txObject.getSessionHolder()));
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (Exception ex) {
            if (txObject.isNewSession()) {
                try {
                    if (session != null && session.getTransaction().isActive()) {
                        session.getTransaction().rollback();
                    }
                }
                catch (Throwable ex2) {
                    this.logger.debug((Object)"Could not rollback Session after failed transaction begin", (Throwable)ex);
                }
                finally {
                    DatastoreUtils.closeSession(session);
                }
            }
            throw new CannotCreateTransactionException("Could not open Datastore Session for transaction", (Throwable)ex);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        SessionHolder sessionHolder = txObject.getSessionHolder();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Datastore transaction on Session [" + sessionHolder.getSession() + "]"));
        }
        try {
            if (sessionHolder.getSession() != null) {
                sessionHolder.getSession().flush();
            }
            txObject.getTransaction().commit();
        }
        catch (DataAccessException ex) {
            throw new TransactionSystemException("Could not commit Datastore transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        SessionHolder sessionHolder = txObject.getSessionHolder();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Datastore transaction on Session [" + sessionHolder.getSession() + "]"));
        }
        try {
            txObject.getTransaction().rollback();
        }
        catch (DataAccessException ex) {
            throw new TransactionSystemException("Could not rollback Datastore transaction", (Throwable)ex);
        }
        finally {
            if (sessionHolder.getSession() != null) {
                sessionHolder.getSession().clear();
            }
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionObject txObject = (TransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            DatastoreUtils.closeSession(txObject.getSessionHolder().getSession());
        }
        txObject.getSessionHolder().setSynchronizedWithTransaction(false);
    }
}

