/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.extension.ExtensionUtil;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;
import spock.lang.AutoCleanup;

public class AutoCleanupInterceptor
implements IMethodInterceptor {
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();

    public void add(FieldInfo field) {
        this.fields.add(field);
    }

    public void install(List<IMethodInterceptor> interceptors) {
        if (this.fields.isEmpty()) {
            return;
        }
        Collections.reverse(this.fields);
        interceptors.add(this);
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        try {
            invocation.proceed();
        }
        catch (Throwable t) {
            exceptions.add(t);
        }
        for (FieldInfo field : this.fields) {
            AutoCleanup annotation = field.getAnnotation(AutoCleanup.class);
            try {
                Object value = field.readValue(invocation.getInstance());
                if (value == null) continue;
                GroovyRuntimeUtil.invokeMethod(value, annotation.value(), new Object[0]);
            }
            catch (Throwable t) {
                if (annotation.quiet()) continue;
                exceptions.add(t);
            }
        }
        ExtensionUtil.throwAll(exceptions);
    }
}

