/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.spockframework.util.Assert;

public abstract class AbstractExpressionConverter<T>
implements GroovyCodeVisitor {
    protected T result;

    public T convert(Expression expr) {
        this.result = null;
        expr.visit((GroovyCodeVisitor)this);
        if (this.result == null) {
            Assert.fail("No result set for expression: " + expr, new Object[0]);
        }
        T temp = this.result;
        this.result = null;
        return temp;
    }

    protected List<T> convertAll(List<? extends Expression> expressions) {
        ArrayList<T> converted = new ArrayList<T>(expressions.size());
        for (Expression expression : expressions) {
            converted.add(this.convert(expression));
        }
        return converted;
    }

    protected void unsupported() {
        throw new UnsupportedOperationException();
    }

    public final void visitBlockStatement(BlockStatement statement) {
        this.unsupported();
    }

    public final void visitForLoop(ForStatement forLoop) {
        this.unsupported();
    }

    public final void visitWhileLoop(WhileStatement loop) {
        this.unsupported();
    }

    public final void visitDoWhileLoop(DoWhileStatement loop) {
        this.unsupported();
    }

    public final void visitIfElse(IfStatement ifElse) {
        this.unsupported();
    }

    public final void visitExpressionStatement(ExpressionStatement statement) {
        this.unsupported();
    }

    public final void visitReturnStatement(ReturnStatement statement) {
        this.unsupported();
    }

    public final void visitAssertStatement(AssertStatement statement) {
        this.unsupported();
    }

    public final void visitTryCatchFinally(TryCatchStatement finally1) {
        this.unsupported();
    }

    public final void visitSwitch(SwitchStatement statement) {
        this.unsupported();
    }

    public final void visitCaseStatement(CaseStatement statement) {
        this.unsupported();
    }

    public final void visitBreakStatement(BreakStatement statement) {
        this.unsupported();
    }

    public final void visitContinueStatement(ContinueStatement statement) {
        this.unsupported();
    }

    public final void visitThrowStatement(ThrowStatement statement) {
        this.unsupported();
    }

    public final void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.unsupported();
    }

    public final void visitCatchStatement(CatchStatement statement) {
        this.unsupported();
    }
}

