/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.gorm;

import grails.compiler.ast.AstTransformer;
import grails.compiler.ast.GrailsArtefactClassInjector;
import grails.persistence.Entity;
import groovy.transform.Canonical;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.io.support.GrailsResourceUtils;

@AstTransformer
public class GormTransformer
implements GrailsArtefactClassInjector {
    public static final int PUBLIC_STATIC_MODIFIER = 9;
    public static final String NEW_INSTANCE_METHOD = "newInstance";
    public static final String CREATE_METHOD_NAME = "create";
    private static final Set<String> TRANSFORMED_CLASSES = new HashSet<String>();

    public String[] getArtefactTypes() {
        return new String[]{"Domain"};
    }

    public boolean shouldInject(URL url) {
        return GrailsResourceUtils.isDomainClass((URL)url);
    }

    public static Collection<String> getKnownEntityNames() {
        return Collections.unmodifiableCollection(TRANSFORMED_CLASSES);
    }

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, classNode);
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        if (GrailsASTUtils.hasAnnotation((ClassNode)classNode, Canonical.class)) {
            GrailsASTUtils.error((SourceUnit)source, (ASTNode)classNode, (String)("Class [" + classNode.getName() + "] is marked with @groovy.transform.Canonical which is not supported for GORM entities."), (boolean)true);
        }
        classNode.setUsingGenerics(true);
        GrailsASTUtils.addAnnotationIfNecessary((ClassNode)classNode, Entity.class);
        TRANSFORMED_CLASSES.add(classNode.getName());
        BlockStatement methodBody = new BlockStatement();
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(classNode), NEW_INSTANCE_METHOD, (Expression)ZERO_ARGS)));
        MethodNode methodNode = classNode.getDeclaredMethod(CREATE_METHOD_NAME, ZERO_PARAMETERS);
        classNode = GrailsASTUtils.nonGeneric((ClassNode)classNode);
        if (methodNode == null) {
            classNode.addMethod(new MethodNode(CREATE_METHOD_NAME, 9, classNode, ZERO_PARAMETERS, null, (Statement)methodBody));
        }
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, classNode);
    }
}

