/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.filter;

import reactor.rx.action.Action;

public class ElementAtAction<T>
extends Action<T, T> {
    private final int index;
    private final T defaultValue;
    private final boolean defaultProvided;
    private int currentIndex = 0;

    public ElementAtAction(int index) {
        this(index, null, false);
    }

    public ElementAtAction(int index, T defaultValue) {
        this(index, defaultValue, true);
    }

    public ElementAtAction(int index, T defaultValue, boolean defaultProvided) {
        this.defaultValue = defaultValue;
        this.defaultProvided = defaultProvided;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index should be >= 0");
        }
        this.index = index;
    }

    @Override
    protected void doNext(T ev) {
        if (this.currentIndex == this.index) {
            this.cancel();
            this.broadcastNext(ev);
            this.broadcastComplete();
        }
        ++this.currentIndex;
    }

    @Override
    public void doComplete() {
        if (this.currentIndex <= this.index) {
            if (this.defaultProvided) {
                this.broadcastNext(this.defaultValue);
            } else {
                this.broadcastError(new IndexOutOfBoundsException("index is out of bounds"));
                return;
            }
        }
        super.doComplete();
    }
}

