/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.GradleDistributionLocator;
import org.gradle.api.internal.classpath.EffectiveClassPath;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleRegistry
implements ModuleRegistry,
GradleDistributionLocator {
    private final ClassLoader classLoader;
    private final File distDir;
    private final Map<String, Module> modules = new HashMap<String, Module>();
    private final List<File> classpath = new ArrayList<File>();
    private final Map<String, File> classpathJars = new LinkedHashMap<String, File>();
    private final List<File> libDirs = new ArrayList<File>();

    public DefaultModuleRegistry() {
        this(DefaultModuleRegistry.class.getClassLoader(), DefaultModuleRegistry.findDistDir());
    }

    DefaultModuleRegistry(ClassLoader classLoader, File distDir) {
        this.classLoader = classLoader;
        this.distDir = distDir;
        for (File classpathFile : new EffectiveClassPath(classLoader).getAsFiles()) {
            this.classpath.add(classpathFile);
            if (!classpathFile.isFile() || this.classpathJars.containsKey(classpathFile.getName())) continue;
            this.classpathJars.put(classpathFile.getName(), classpathFile);
        }
        if (distDir != null) {
            this.libDirs.add(new File(distDir, "lib"));
            this.libDirs.add(new File(distDir, "lib/plugins"));
        }
    }

    private static File findDistDir() {
        File codeSource = ClasspathUtil.getClasspathForClass(DefaultModuleRegistry.class);
        if (codeSource.isFile()) {
            File libDir = codeSource.getParentFile();
            if (!libDir.getName().equals("lib") || !new File(libDir, "plugins").isDirectory()) {
                return null;
            }
            return libDir.getParentFile();
        }
        return null;
    }

    public Set<File> getFullClasspath() {
        return new LinkedHashSet<File>(this.classpath);
    }

    @Override
    public File getGradleHome() {
        return this.distDir;
    }

    @Override
    public Module getExternalModule(String name) {
        File externalJar = this.findExternalJar(name);
        return new DefaultModule(name, Collections.singleton(externalJar), Collections.<File>emptySet(), Collections.<Module>emptySet());
    }

    @Override
    public Module getModule(String name) {
        Module module = this.modules.get(name);
        if (module == null) {
            module = this.loadModule(name);
            this.modules.put(name, module);
        }
        return module;
    }

    private Module loadModule(String moduleName) {
        File jarFile = this.findModuleJar(moduleName);
        if (jarFile != null) {
            LinkedHashSet<File> implementationClasspath = new LinkedHashSet<File>();
            implementationClasspath.add(jarFile);
            Properties properties = this.loadModuleProperties(moduleName, jarFile);
            return this.module(moduleName, properties, implementationClasspath);
        }
        String resourceName = String.format("%s-classpath.properties", moduleName);
        URL propertiesUrl = this.classLoader.getResource(resourceName);
        if (propertiesUrl != null) {
            LinkedHashSet<File> implementationClasspath = new LinkedHashSet<File>();
            this.findImplementationClasspath(moduleName, implementationClasspath);
            implementationClasspath.add(ClasspathUtil.getClasspathForResource(propertiesUrl, resourceName));
            Properties properties = GUtil.loadProperties(propertiesUrl);
            return this.module(moduleName, properties, implementationClasspath);
        }
        if (this.distDir == null) {
            throw new UnknownModuleException(String.format("Cannot locate classpath manifest for module '%s' in classpath.", moduleName));
        }
        throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", moduleName, this.distDir));
    }

    private Module module(String moduleName, Properties properties, Set<File> implementationClasspath) {
        LinkedHashSet<File> runtimeClasspath = new LinkedHashSet<File>();
        String runtime = properties.getProperty("runtime");
        for (String jarName : this.split(runtime)) {
            runtimeClasspath.add(this.findDependencyJar(moduleName, jarName));
        }
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        String projects = properties.getProperty("projects");
        for (String project : this.split(projects)) {
            modules.add(this.getModule(project));
        }
        return new DefaultModule(moduleName, implementationClasspath, runtimeClasspath, modules);
    }

    private String[] split(String value) {
        if (value == null) {
            return new String[0];
        }
        if ((value = value.trim()).length() == 0) {
            return new String[0];
        }
        return value.split(",");
    }

    private void findImplementationClasspath(String name, Collection<File> implementationClasspath) {
        ArrayList<String> suffixes = new ArrayList<String>();
        Matcher matcher = Pattern.compile("gradle-(.+)").matcher(name);
        matcher.matches();
        String projectDirName = matcher.group(1);
        String projectName = this.toCamelCase(projectDirName);
        suffixes.add(String.format("/out/production/%s", projectName).replace('/', File.separatorChar));
        suffixes.add(String.format("/%s/bin", projectDirName).replace('/', File.separatorChar));
        suffixes.add(String.format("/%s/src/main/resources", projectDirName).replace('/', File.separatorChar));
        suffixes.add(String.format("/%s/build/classes/main", projectDirName).replace('/', File.separatorChar));
        suffixes.add(String.format("/%s/build/resources/main", projectDirName).replace('/', File.separatorChar));
        for (File file : this.classpath) {
            if (!file.isDirectory()) continue;
            for (String suffix : suffixes) {
                if (!file.getAbsolutePath().endsWith(suffix)) continue;
                implementationClasspath.add(file);
            }
        }
    }

    private String toCamelCase(String name) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = Pattern.compile("-([^-])").matcher(name);
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            result.append(matcher.group(1).toUpperCase());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadModuleProperties(String name, File jarFile) {
        Properties properties;
        ZipFile zipFile = new ZipFile(jarFile);
        try {
            ZipEntry entry = zipFile.getEntry(String.format("%s-classpath.properties", name));
            properties = GUtil.loadProperties(zipFile.getInputStream(entry));
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        zipFile.close();
        return properties;
    }

    private File findModuleJar(String name) {
        Pattern pattern = Pattern.compile(Pattern.quote(name) + "-\\d.+\\.jar");
        for (File libDir : this.libDirs) {
            for (File file : libDir.listFiles()) {
                if (!pattern.matcher(file.getName()).matches()) continue;
                return file;
            }
        }
        return null;
    }

    private File findExternalJar(String name) {
        Pattern pattern = Pattern.compile(Pattern.quote(name) + "-\\d.+\\.jar");
        for (File file : this.classpath) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            return file;
        }
        for (File libDir : this.libDirs) {
            for (File file : libDir.listFiles()) {
                if (!pattern.matcher(file.getName()).matches()) continue;
                return file;
            }
        }
        throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", name, this.distDir));
    }

    private File findDependencyJar(String module, String name) {
        File jarFile = this.classpathJars.get(name);
        if (jarFile != null) {
            return jarFile;
        }
        if (this.distDir == null) {
            throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath.", name, module));
        }
        for (File libDir : this.libDirs) {
            jarFile = new File(libDir, name);
            if (!jarFile.isFile()) continue;
            return jarFile;
        }
        throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath or distribution directory '%s'", name, module, this.distDir));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultModule
    implements Module {
        private final String name;
        private final ClassPath implementationClasspath;
        private final ClassPath runtimeClasspath;
        private final Set<Module> modules;
        private final ClassPath classpath;

        public DefaultModule(String name, Set<File> implementationClasspath, Set<File> runtimeClasspath, Set<Module> modules) {
            this.name = name;
            this.implementationClasspath = new DefaultClassPath((Iterable<File>)implementationClasspath);
            this.runtimeClasspath = new DefaultClassPath((Iterable<File>)runtimeClasspath);
            this.modules = modules;
            LinkedHashSet<File> classpath = new LinkedHashSet<File>();
            classpath.addAll(implementationClasspath);
            classpath.addAll(runtimeClasspath);
            this.classpath = new DefaultClassPath((Iterable<File>)classpath);
        }

        public String toString() {
            return String.format("module '%s'", this.name);
        }

        @Override
        public Set<Module> getRequiredModules() {
            return this.modules;
        }

        @Override
        public ClassPath getImplementationClasspath() {
            return this.implementationClasspath;
        }

        @Override
        public ClassPath getRuntimeClasspath() {
            return this.runtimeClasspath;
        }

        @Override
        public ClassPath getClasspath() {
            return this.classpath;
        }

        @Override
        public Set<Module> getAllRequiredModules() {
            LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
            modules.add(this);
            for (Module module : this.modules) {
                modules.addAll(module.getAllRequiredModules());
            }
            return modules;
        }
    }
}

