/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatteningNotationParser<T>
implements NotationParser<Object, Set<T>> {
    private final NotationParser<Object, T> delegate;

    public FlatteningNotationParser(NotationParser<Object, T> delegate) {
        assert (delegate != null) : "delegate cannot be null";
        this.delegate = delegate;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        this.delegate.describe(candidateFormats);
        candidateFormats.add("Collections or arrays of any other supported format. Nested collections/arrays will be flattened.");
    }

    @Override
    public Set<T> parseNotation(Object notation) {
        LinkedHashSet<T> out = new LinkedHashSet<T>();
        Collection notations = GUtil.collectionize(notation);
        for (Object n : notations) {
            out.add(this.delegate.parseNotation(n));
        }
        return out;
    }
}

