/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.internal.TimeProvider;
import org.gradle.internal.progress.OperationIdentifier;
import org.gradle.internal.progress.OperationsHierarchy;
import org.gradle.internal.progress.OperationsHierarchyKeeper;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressListener;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.util.GUtil;

public class DefaultProgressLoggerFactory
implements ProgressLoggerFactory {
    private final ProgressListener progressListener;
    private final TimeProvider timeProvider;
    private final OperationsHierarchyKeeper hierarchyKeeper = new OperationsHierarchyKeeper();

    public DefaultProgressLoggerFactory(ProgressListener progressListener, TimeProvider timeProvider) {
        this.progressListener = progressListener;
        this.timeProvider = timeProvider;
    }

    public ProgressLogger newOperation(Class loggerCategory) {
        return this.newOperation(loggerCategory.getName());
    }

    public ProgressLogger newOperation(String loggerCategory) {
        return this.init(loggerCategory, null);
    }

    public ProgressLogger newOperation(Class loggerCategory, ProgressLogger parent) {
        return this.init(loggerCategory.toString(), parent);
    }

    private ProgressLogger init(String loggerCategory, ProgressLogger parentHint) {
        return new ProgressLoggerImpl(this.hierarchyKeeper.currentHierarchy(parentHint), loggerCategory, this.progressListener, this.timeProvider);
    }

    private static class ProgressLoggerImpl
    implements ProgressLogger {
        private final OperationsHierarchy hierarchy;
        private final String category;
        private final ProgressListener listener;
        private final TimeProvider timeProvider;
        private String description;
        private String shortDescription;
        private String loggingHeader;
        private State state = State.idle;

        public ProgressLoggerImpl(OperationsHierarchy hierarchy, String category, ProgressListener listener, TimeProvider timeProvider) {
            this.hierarchy = hierarchy;
            this.category = category;
            this.listener = listener;
            this.timeProvider = timeProvider;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.assertCanConfigure();
            this.description = description;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public void setShortDescription(String shortDescription) {
            this.assertCanConfigure();
            this.shortDescription = shortDescription;
        }

        public String getLoggingHeader() {
            return this.loggingHeader;
        }

        public void setLoggingHeader(String loggingHeader) {
            this.assertCanConfigure();
            this.loggingHeader = loggingHeader;
        }

        public ProgressLogger start(String description, String shortDescription) {
            this.setDescription(description);
            this.setShortDescription(shortDescription);
            this.started();
            return this;
        }

        public void started() {
            this.started(null);
        }

        public void started(String status) {
            if (!GUtil.isTrue(this.description)) {
                throw new IllegalStateException("A description must be specified before this operation is started.");
            }
            if (this.state == State.started) {
                throw new IllegalStateException("This operation has already been started.");
            }
            this.assertNotCompleted();
            this.state = State.started;
            OperationIdentifier id = this.hierarchy.start();
            this.listener.started(new ProgressStartEvent(id.getId(), id.getParentId(), this.timeProvider.getCurrentTime(), this.category, this.description, this.shortDescription, this.loggingHeader, this.toStatus(status)));
        }

        public void progress(String status) {
            this.assertStarted();
            this.assertNotCompleted();
            this.listener.progress(new ProgressEvent(this.hierarchy.currentOperationId(), this.timeProvider.getCurrentTime(), this.category, this.toStatus(status)));
        }

        public void completed() {
            this.completed(null);
        }

        public void completed(String status) {
            this.assertStarted();
            this.assertNotCompleted();
            this.state = State.completed;
            this.listener.completed(new ProgressCompleteEvent(this.hierarchy.completeCurrentOperation(), this.timeProvider.getCurrentTime(), this.category, this.description, this.toStatus(status)));
        }

        public long currentOperationId() {
            return this.hierarchy.currentOperationId();
        }

        private String toStatus(String status) {
            return status == null ? "" : status;
        }

        private void assertNotCompleted() {
            if (this.state == State.completed) {
                throw new IllegalStateException("This operation has completed.");
            }
        }

        private void assertStarted() {
            if (this.state == State.idle) {
                throw new IllegalStateException("This operation has not been started.");
            }
        }

        private void assertCanConfigure() {
            if (this.state != State.idle) {
                throw new IllegalStateException("Cannot configure this operation once it has started.");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            idle,
            started,
            completed;

        }
    }
}

