/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.processor.InsufficientCapacityException;
import reactor.core.support.Assert;
import reactor.core.support.Recyclable;
import reactor.fn.Consumer;

public abstract class AbstractLifecycleDispatcher
implements Dispatcher {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    private final AtomicBoolean alive = new AtomicBoolean(true);
    public final ClassLoader context = new ClassLoader(Thread.currentThread().getContextClassLoader()){};

    protected AbstractLifecycleDispatcher() {
    }

    @Override
    public boolean alive() {
        return this.alive.get();
    }

    @Override
    public boolean awaitAndShutdown() {
        return this.awaitAndShutdown(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        this.alive.compareAndSet(true, false);
    }

    @Override
    public void forceShutdown() {
        this.alive.compareAndSet(true, false);
    }

    @Override
    public boolean inContext() {
        return this.context == Thread.currentThread().getContextClassLoader();
    }

    protected final ClassLoader getContext() {
        return this.context;
    }

    @Override
    public final <E> void tryDispatch(E event, Consumer<E> eventConsumer, Consumer<Throwable> errorConsumer) throws InsufficientCapacityException {
        Assert.isTrue(this.alive(), "This Dispatcher has been shut down.");
        boolean isInContext = this.inContext();
        Task task = isInContext ? this.allocateRecursiveTask() : this.tryAllocateTask();
        task.setData(event).setErrorConsumer(errorConsumer).setEventConsumer(eventConsumer);
        if (!isInContext) {
            this.execute(task);
        } else {
            this.scheduleLater(task);
        }
    }

    @Override
    public final <E> void dispatch(E event, Consumer<E> eventConsumer, Consumer<Throwable> errorConsumer) {
        Assert.isTrue(this.alive(), "This Dispatcher has been shut down.");
        Assert.isTrue(eventConsumer != null, "The signal consumer has not been passed.");
        boolean isInContext = this.inContext();
        Task task = isInContext ? this.allocateRecursiveTask() : this.allocateTask();
        task.setData(event).setErrorConsumer(errorConsumer).setEventConsumer(eventConsumer);
        if (!isInContext) {
            this.execute(task);
        } else {
            this.scheduleLater(task);
        }
    }

    @Override
    public void execute(final Runnable command) {
        this.dispatch(null, new Consumer<Object>(){

            @Override
            public void accept(Object ev) {
                command.run();
            }
        }, null);
    }

    protected void scheduleLater(Task task) {
    }

    protected Task tryAllocateTask() throws InsufficientCapacityException {
        return this.allocateTask();
    }

    protected abstract Task allocateTask();

    protected abstract Task allocateRecursiveTask();

    protected abstract void execute(Task var1);

    protected static void route(Task task) {
        try {
            if (task.eventConsumer == null) {
                return;
            }
            task.eventConsumer.accept(task.data);
        }
        catch (Exception e) {
            if (task.errorConsumer != null) {
                task.errorConsumer.accept(e);
            } else if (Environment.alive()) {
                Environment.get().routeError(e);
            }
        }
        finally {
            task.recycle();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName().replaceAll("Dispatcher", "");
    }

    public abstract class Task
    implements Runnable,
    Recyclable {
        protected volatile Object data;
        protected volatile Consumer eventConsumer;
        protected volatile Consumer<Throwable> errorConsumer;

        public Task setData(Object data) {
            this.data = data;
            return this;
        }

        public Task setEventConsumer(Consumer<?> eventConsumer) {
            this.eventConsumer = eventConsumer;
            return this;
        }

        public Task setErrorConsumer(Consumer<Throwable> errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }

        @Override
        public void recycle() {
            this.data = null;
            this.errorConsumer = null;
            this.eventConsumer = null;
        }
    }
}

