/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.corrector.CorrectionTableModel;

public abstract class CorrectionTable<T extends CorrectionTableModel<?>>
extends JTable {
    private static final int MAX_VISIBLE_LINES = 10;
    private static volatile BoldRenderer boldRenderer;

    protected CorrectionTable(T t) {
        super((TableModel)t);
        int n = ((CorrectionTableModel)t).getCorrections().size();
        int n2 = n > 10 ? 10 : n;
        this.setPreferredScrollableViewportSize(new Dimension(400, n2 * this.getRowHeight()));
        this.getColumnModel().getColumn(((CorrectionTableModel)t).getApplyColumn()).setPreferredWidth(40);
        this.setRowSelectionAllowed(false);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (((CorrectionTableModel)this.getCorrectionTableModel()).isBoldCell(n, n2)) {
            if (boldRenderer == null) {
                boldRenderer = new BoldRenderer();
            }
            return boldRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public T getCorrectionTableModel() {
        return (T)((CorrectionTableModel)this.getModel());
    }

    public static class BoldRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Font font = this.getFont();
            this.setFont(new Font(font.getName(), font.getStyle() | 1, font.getSize()));
            this.setText((String)object);
            return this;
        }
    }
}

