/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class History {
    private List<HistoryOsmPrimitive> versions;
    private final long id;
    private final OsmPrimitiveType type;

    private static History filter(History history, FilterPredicate filterPredicate) {
        ArrayList<HistoryOsmPrimitive> arrayList = new ArrayList<HistoryOsmPrimitive>();
        for (HistoryOsmPrimitive historyOsmPrimitive : history.versions) {
            if (!filterPredicate.matches(historyOsmPrimitive)) continue;
            arrayList.add(historyOsmPrimitive);
        }
        return new History(history.id, history.type, arrayList);
    }

    protected History(long l, OsmPrimitiveType osmPrimitiveType, List<HistoryOsmPrimitive> list) {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        this.id = l;
        this.type = osmPrimitiveType;
        this.versions = new ArrayList<HistoryOsmPrimitive>();
        if (list != null) {
            this.versions.addAll(list);
        }
    }

    public History sortAscending() {
        ArrayList<HistoryOsmPrimitive> arrayList = new ArrayList<HistoryOsmPrimitive>(this.versions);
        Collections.sort(arrayList, new Comparator<HistoryOsmPrimitive>(){

            @Override
            public int compare(HistoryOsmPrimitive historyOsmPrimitive, HistoryOsmPrimitive historyOsmPrimitive2) {
                return historyOsmPrimitive.compareTo(historyOsmPrimitive2);
            }
        });
        return new History(this.id, this.type, arrayList);
    }

    public History sortDescending() {
        ArrayList<HistoryOsmPrimitive> arrayList = new ArrayList<HistoryOsmPrimitive>(this.versions);
        Collections.sort(arrayList, new Comparator<HistoryOsmPrimitive>(){

            @Override
            public int compare(HistoryOsmPrimitive historyOsmPrimitive, HistoryOsmPrimitive historyOsmPrimitive2) {
                return historyOsmPrimitive2.compareTo(historyOsmPrimitive);
            }
        });
        return new History(this.id, this.type, arrayList);
    }

    public History from(final Date date) {
        return History.filter(this, new FilterPredicate(){

            @Override
            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getTimestamp().compareTo(date) >= 0;
            }
        });
    }

    public History until(final Date date) {
        return History.filter(this, new FilterPredicate(){

            @Override
            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getTimestamp().compareTo(date) <= 0;
            }
        });
    }

    public History between(Date date, Date date2) {
        return this.from(date).until(date2);
    }

    public History from(final long l) {
        return History.filter(this, new FilterPredicate(){

            @Override
            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getVersion() >= l;
            }
        });
    }

    public History until(final long l) {
        return History.filter(this, new FilterPredicate(){

            @Override
            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getVersion() <= l;
            }
        });
    }

    public History between(long l, long l2) {
        return this.from(l).until(l2);
    }

    public History forUserId(final long l) {
        return History.filter(this, new FilterPredicate(){

            @Override
            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getUser() != null && historyOsmPrimitive.getUser().getId() == l;
            }
        });
    }

    public long getId() {
        return this.id;
    }

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.id, this.type);
    }

    public boolean contains(long l) {
        for (HistoryOsmPrimitive historyOsmPrimitive : this.versions) {
            if (!historyOsmPrimitive.matches(this.id, l)) continue;
            return true;
        }
        return false;
    }

    public HistoryOsmPrimitive getByVersion(long l) {
        for (HistoryOsmPrimitive historyOsmPrimitive : this.versions) {
            if (!historyOsmPrimitive.matches(this.id, l)) continue;
            return historyOsmPrimitive;
        }
        return null;
    }

    public HistoryOsmPrimitive getByDate(Date date) {
        History history = this.sortAscending();
        if (history.versions.isEmpty()) {
            return null;
        }
        if (history.get(0).getTimestamp().compareTo(date) > 0) {
            return null;
        }
        for (int i = 1; i < history.versions.size(); ++i) {
            if (history.get(i - 1).getTimestamp().compareTo(date) > 0 || history.get(i).getTimestamp().compareTo(date) < 0) continue;
            return history.get(i);
        }
        return history.getLatest();
    }

    public HistoryOsmPrimitive get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.versions.size()) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Parameter ''{0}'' in range 0..{1} expected. Got ''{2}''.", "idx", this.versions.size() - 1, n));
        }
        return this.versions.get(n);
    }

    public HistoryOsmPrimitive getEarliest() {
        if (this.isEmpty()) {
            return null;
        }
        return this.sortAscending().versions.get(0);
    }

    public HistoryOsmPrimitive getLatest() {
        if (this.isEmpty()) {
            return null;
        }
        return this.sortDescending().versions.get(0);
    }

    public int getNumVersions() {
        return this.versions.size();
    }

    public final boolean isEmpty() {
        return this.versions.isEmpty();
    }

    public OsmPrimitiveType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("History [" + (this.type != null ? "type=" + (Object)((Object)this.type) + ", " : "") + "id=" + this.id);
        if (this.versions != null) {
            stringBuilder.append(", versions=\n");
            for (HistoryOsmPrimitive historyOsmPrimitive : this.versions) {
                stringBuilder.append('\t').append(historyOsmPrimitive).append(",\n");
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static interface FilterPredicate {
        public boolean matches(HistoryOsmPrimitive var1);
    }
}

