/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class HistoryBrowserModel
extends Observable
implements MapView.LayerChangeListener,
DataSetListener {
    private History history;
    private HistoryOsmPrimitive reference;
    private HistoryOsmPrimitive current;
    private HistoryOsmPrimitive latest;
    private final VersionTableModel versionTableModel = new VersionTableModel();
    private final TagTableModel currentTagTableModel = new TagTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private final TagTableModel referenceTagTableModel = new TagTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
    private final DiffTableModel currentRelationMemberTableModel;
    private final DiffTableModel referenceRelationMemberTableModel;
    private final DiffTableModel referenceNodeListTableModel = new DiffTableModel();
    private final DiffTableModel currentNodeListTableModel = new DiffTableModel();

    public HistoryBrowserModel() {
        this.currentRelationMemberTableModel = new DiffTableModel();
        this.referenceRelationMemberTableModel = new DiffTableModel();
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer != null) {
            osmDataLayer.data.addDataSetListener(this);
        }
        MapView.addLayerChangeListener(this);
    }

    public HistoryBrowserModel(History history) {
        this();
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        this.setHistory(history);
    }

    public History getHistory() {
        return this.history;
    }

    protected boolean canShowAsLatest(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        if (osmPrimitive.isNew() || !osmPrimitive.isUsable()) {
            return false;
        }
        try {
            HistoryOsmPrimitive.forOsmPrimitive(osmPrimitive);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.history == null) {
            return false;
        }
        if (this.history.getByVersion(osmPrimitive.getVersion()) != null) {
            return osmPrimitive.isModified();
        }
        return this.history.getLatest().getVersion() <= (long)osmPrimitive.getVersion();
    }

    public void setHistory(History history) {
        this.history = history;
        if (history.getNumVersions() > 0) {
            OsmPrimitive osmPrimitive;
            HistoryOsmPrimitive historyOsmPrimitive = null;
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            if (osmDataLayer != null && this.canShowAsLatest(osmPrimitive = osmDataLayer.data.getPrimitiveById(history.getId(), history.getType()))) {
                historyOsmPrimitive = new HistoryPrimitiveBuilder().build(osmPrimitive);
            }
            if (historyOsmPrimitive == null) {
                this.current = history.getLatest();
                int n = history.getNumVersions() - 2;
                this.reference = n < 0 ? history.getEarliest() : history.get(n);
            } else {
                this.reference = history.getLatest();
                this.current = historyOsmPrimitive;
            }
            this.setLatest(historyOsmPrimitive);
        }
        this.initTagTableModels();
        this.fireModelChange();
    }

    protected void fireModelChange() {
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
        this.versionTableModel.fireTableDataChanged();
    }

    public VersionTableModel getVersionTableModel() {
        return this.versionTableModel;
    }

    protected void initTagTableModels() {
        this.currentTagTableModel.initKeyList();
        this.referenceTagTableModel.initKeyList();
    }

    protected void initNodeListTableModels() {
        if (this.current.getType() != OsmPrimitiveType.WAY || this.reference.getType() != OsmPrimitiveType.WAY) {
            return;
        }
        TwoColumnDiff twoColumnDiff = new TwoColumnDiff(((HistoryWay)this.reference).getNodes().toArray(), ((HistoryWay)this.current).getNodes().toArray());
        this.referenceNodeListTableModel.setRows(twoColumnDiff.referenceDiff, twoColumnDiff.referenceReversed);
        this.currentNodeListTableModel.setRows(twoColumnDiff.currentDiff, false);
    }

    protected void initMemberListTableModels() {
        if (this.current.getType() != OsmPrimitiveType.RELATION || this.reference.getType() != OsmPrimitiveType.RELATION) {
            return;
        }
        TwoColumnDiff twoColumnDiff = new TwoColumnDiff(((HistoryRelation)this.reference).getMembers().toArray(), ((HistoryRelation)this.current).getMembers().toArray());
        this.referenceRelationMemberTableModel.setRows(twoColumnDiff.referenceDiff, twoColumnDiff.referenceReversed);
        this.currentRelationMemberTableModel.setRows(twoColumnDiff.currentDiff, false);
    }

    public TagTableModel getTagTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentTagTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceTagTableModel;
        }
        return null;
    }

    public DiffTableModel getNodeListTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentNodeListTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceNodeListTableModel;
        }
        return null;
    }

    public DiffTableModel getRelationMemberTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentRelationMemberTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceRelationMemberTableModel;
        }
        return null;
    }

    public void setReferencePointInTime(HistoryOsmPrimitive historyOsmPrimitive) {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "reference");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set reference primitive.", new Object[0]));
        }
        if (historyOsmPrimitive.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", historyOsmPrimitive.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive historyOsmPrimitive2 = this.history.getByVersion(historyOsmPrimitive.getVersion());
        if (historyOsmPrimitive2 == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference version {0} not available in history.", historyOsmPrimitive.getVersion()));
        }
        this.reference = historyOsmPrimitive;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
    }

    public void setCurrentPointInTime(HistoryOsmPrimitive historyOsmPrimitive) {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "current");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set current primitive.", new Object[0]));
        }
        if (historyOsmPrimitive.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", historyOsmPrimitive.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive historyOsmPrimitive2 = this.history.getByVersion(historyOsmPrimitive.getVersion());
        if (historyOsmPrimitive2 == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set current primitive. Current version {0} not available in history.", historyOsmPrimitive.getVersion()));
        }
        this.current = historyOsmPrimitive;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
    }

    public HistoryOsmPrimitive getCurrentPointInTime() {
        return this.getPointInTime(PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getReferencePointInTime() {
        return this.getPointInTime(PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getPointInTime(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "type");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.current;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.reference;
        }
        return null;
    }

    public boolean isLatest(HistoryOsmPrimitive historyOsmPrimitive) {
        if (historyOsmPrimitive == null) {
            return false;
        }
        return historyOsmPrimitive == this.latest;
    }

    protected void setLatest(HistoryOsmPrimitive historyOsmPrimitive) {
        if (historyOsmPrimitive == null) {
            if (this.current == this.latest) {
                this.current = this.history.getLatest();
            }
            if (this.reference == this.latest) {
                this.current = this.history.getLatest();
            }
            this.latest = null;
        } else {
            if (this.current == this.latest) {
                this.current = historyOsmPrimitive;
            }
            if (this.reference == this.latest) {
                this.reference = historyOsmPrimitive;
            }
            this.latest = historyOsmPrimitive;
        }
        this.fireModelChange();
    }

    public void unlinkAsListener() {
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer != null) {
            osmDataLayer.data.removeDataSetListener(this);
        }
        MapView.removeLayerChangeListener(this);
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
        Node node = nodeMovedEvent.getNode();
        if (!node.isNew() && node.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(node));
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        for (OsmPrimitive osmPrimitive : primitivesAddedEvent.getPrimitives()) {
            if (!this.canShowAsLatest(osmPrimitive)) continue;
            this.setLatest(new HistoryPrimitiveBuilder().build(osmPrimitive));
        }
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        for (OsmPrimitive osmPrimitive : primitivesRemovedEvent.getPrimitives()) {
            if (osmPrimitive.isNew() || osmPrimitive.getId() != this.history.getId()) continue;
            this.setLatest(null);
        }
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        Relation relation = relationMembersChangedEvent.getRelation();
        if (!relation.isNew() && relation.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(relation));
        }
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        OsmPrimitive osmPrimitive = tagsChangedEvent.getPrimitive();
        if (!osmPrimitive.isNew() && osmPrimitive.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(osmPrimitive));
        }
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
        Way way = wayNodesChangedEvent.getChangedWay();
        if (!way.isNew() && way.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(way));
        }
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        OsmPrimitive osmPrimitive = dataChangedEvent.getDataset().getPrimitiveById(this.history.getId(), this.history.getType());
        HistoryOsmPrimitive historyOsmPrimitive = this.canShowAsLatest(osmPrimitive) ? new HistoryPrimitiveBuilder().build(osmPrimitive) : null;
        this.setLatest(historyOsmPrimitive);
        this.fireModelChange();
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        OsmDataLayer osmDataLayer;
        if (layer instanceof OsmDataLayer) {
            osmDataLayer = (OsmDataLayer)layer;
            osmDataLayer.data.removeDataSetListener(this);
        }
        if (!(layer2 instanceof OsmDataLayer)) {
            this.latest = null;
            this.fireModelChange();
            return;
        }
        osmDataLayer = (OsmDataLayer)layer2;
        osmDataLayer.data.addDataSetListener(this);
        OsmPrimitive osmPrimitive = osmDataLayer.data.getPrimitiveById(this.history.getId(), this.history.getType());
        HistoryOsmPrimitive historyOsmPrimitive = this.canShowAsLatest(osmPrimitive) ? new HistoryPrimitiveBuilder().build(osmPrimitive) : null;
        this.setLatest(historyOsmPrimitive);
        this.fireModelChange();
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
    }

    static class HistoryPrimitiveBuilder
    extends AbstractVisitor {
        private HistoryOsmPrimitive clone;

        HistoryPrimitiveBuilder() {
        }

        @Override
        public void visit(Node node) {
            this.clone = new HistoryNode(node.getId(), node.getVersion(), node.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, node.getCoor(), false);
            this.clone.setTags(node.getKeys());
        }

        @Override
        public void visit(Relation relation) {
            this.clone = new HistoryRelation(relation.getId(), (long)relation.getVersion(), relation.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, false);
            this.clone.setTags(relation.getKeys());
            HistoryRelation historyRelation = (HistoryRelation)this.clone;
            for (RelationMember relationMember : relation.getMembers()) {
                historyRelation.addMember(new RelationMemberData(relationMember.getRole(), relationMember.getType(), relationMember.getUniqueId()));
            }
        }

        @Override
        public void visit(Way way) {
            this.clone = new HistoryWay(way.getId(), (long)way.getVersion(), way.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, false);
            this.clone.setTags(way.getKeys());
            for (Node node : way.getNodes()) {
                ((HistoryWay)this.clone).addNode(node.getUniqueId());
            }
        }

        private static User getCurrentUser() {
            UserInfo userInfo = JosmUserIdentityManager.getInstance().getUserInfo();
            return userInfo == null ? User.getAnonymous() : User.createOsmUser(userInfo.getId(), userInfo.getDisplayName());
        }

        public HistoryOsmPrimitive build(OsmPrimitive osmPrimitive) {
            osmPrimitive.accept(this);
            return this.clone;
        }
    }

    public class TagTableModel
    extends AbstractTableModel {
        private List<String> keys;
        private PointInTimeType pointInTimeType;

        protected void initKeyList() {
            HashSet<String> hashSet = new HashSet<String>();
            if (HistoryBrowserModel.this.current != null) {
                hashSet.addAll(HistoryBrowserModel.this.current.getTags().keySet());
            }
            if (HistoryBrowserModel.this.reference != null) {
                hashSet.addAll(HistoryBrowserModel.this.reference.getTags().keySet());
            }
            this.keys = new ArrayList<String>(hashSet);
            Collections.sort(this.keys);
            this.fireTableDataChanged();
        }

        protected TagTableModel(PointInTimeType pointInTimeType) {
            this.pointInTimeType = pointInTimeType;
            this.initKeyList();
        }

        @Override
        public int getRowCount() {
            if (this.keys == null) {
                return 0;
            }
            return this.keys.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.keys.get(n);
        }

        public boolean hasTag(String string) {
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (historyOsmPrimitive == null) {
                return false;
            }
            return historyOsmPrimitive.hasTag(string);
        }

        public String getValue(String string) {
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (historyOsmPrimitive == null) {
                return null;
            }
            return historyOsmPrimitive.get(string);
        }

        public boolean oppositeHasTag(String string) {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(pointInTimeType);
            if (historyOsmPrimitive == null) {
                return false;
            }
            return historyOsmPrimitive.hasTag(string);
        }

        public String getOppositeValue(String string) {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(pointInTimeType);
            if (historyOsmPrimitive == null) {
                return null;
            }
            return historyOsmPrimitive.get(string);
        }

        public boolean hasSameValueAsOpposite(String string) {
            String string2 = this.getValue(string);
            String string3 = this.getOppositeValue(string);
            if (string2 == null || string3 == null) {
                return false;
            }
            return string2.equals(string3);
        }

        public PointInTimeType getPointInTimeType() {
            return this.pointInTimeType;
        }

        public boolean isCurrentPointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME);
        }

        public boolean isReferencePointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }
    }

    public final class VersionTableModel
    extends AbstractTableModel {
        private VersionTableModel() {
        }

        @Override
        public int getRowCount() {
            if (HistoryBrowserModel.this.history == null) {
                return 0;
            }
            int n = HistoryBrowserModel.this.history.getNumVersions();
            if (HistoryBrowserModel.this.latest != null) {
                ++n;
            }
            return n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return Long.toString(this.getPrimitive(n).getVersion());
                }
                case 1: {
                    return this.isReferencePointInTime(n);
                }
                case 2: {
                    return this.isCurrentPointInTime(n);
                }
                case 3: {
                    HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive(n);
                    if (historyOsmPrimitive != null && historyOsmPrimitive.getTimestamp() != null) {
                        return DateUtils.formatDateTime(historyOsmPrimitive.getTimestamp(), 3, 3);
                    }
                    return null;
                }
                case 4: {
                    User user;
                    HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive(n);
                    if (historyOsmPrimitive != null && (user = historyOsmPrimitive.getUser()) != null) {
                        return user.getName();
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!((Boolean)object).booleanValue()) {
                return;
            }
            switch (n2) {
                case 1: {
                    this.setReferencePointInTime(n);
                    break;
                }
                case 2: {
                    this.setCurrentPointInTime(n);
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1 && n2 <= 2;
        }

        public void setReferencePointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (n == HistoryBrowserModel.this.history.getNumVersions()) {
                if (HistoryBrowserModel.this.latest != null) {
                    HistoryBrowserModel.this.setReferencePointInTime(HistoryBrowserModel.this.latest);
                }
                return;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            HistoryBrowserModel.this.setReferencePointInTime(historyOsmPrimitive);
        }

        public void setCurrentPointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (n == HistoryBrowserModel.this.history.getNumVersions()) {
                if (HistoryBrowserModel.this.latest != null) {
                    HistoryBrowserModel.this.setCurrentPointInTime(HistoryBrowserModel.this.latest);
                }
                return;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            HistoryBrowserModel.this.setCurrentPointInTime(historyOsmPrimitive);
        }

        public boolean isReferencePointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return false;
            }
            if (n == HistoryBrowserModel.this.history.getNumVersions()) {
                return HistoryBrowserModel.this.latest == HistoryBrowserModel.this.reference;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return false;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            return historyOsmPrimitive == HistoryBrowserModel.this.reference;
        }

        public boolean isCurrentPointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return false;
            }
            if (n == HistoryBrowserModel.this.history.getNumVersions()) {
                return HistoryBrowserModel.this.latest == HistoryBrowserModel.this.current;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return false;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            return historyOsmPrimitive == HistoryBrowserModel.this.current;
        }

        public HistoryOsmPrimitive getPrimitive(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return null;
            }
            return this.isLatest(n) ? HistoryBrowserModel.this.latest : HistoryBrowserModel.this.history.get(n);
        }

        public boolean isLatest(int n) {
            return n >= HistoryBrowserModel.this.history.getNumVersions();
        }

        public OsmPrimitive getLatest() {
            if (HistoryBrowserModel.this.latest == null) {
                return null;
            }
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            if (osmDataLayer == null) {
                return null;
            }
            return osmDataLayer.data.getPrimitiveById(HistoryBrowserModel.this.latest.getId(), HistoryBrowserModel.this.latest.getType());
        }

        @Override
        public int getColumnCount() {
            return 6;
        }
    }
}

