/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RecentlyOpenedFilesMenu
extends JMenu {
    private ClearAction clearAction;

    public RecentlyOpenedFilesMenu() {
        super(I18n.tr("Open Recent", new Object[0]));
        this.setToolTipText(I18n.tr("List of recently opened files", new Object[0]));
        this.setIcon(new ImageProvider("openrecent").setSize(ImageProvider.ImageSizes.MENU).get());
        this.putClientProperty("help", HelpUtil.ht("/Action/OpenRecent"));
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                RecentlyOpenedFilesMenu.this.rebuild();
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    private void rebuild() {
        this.removeAll();
        Collection<String> collection = Main.pref.getCollection("file-open.history");
        for (final String string : collection) {
            this.add(new AbstractAction(){
                {
                    this.putValue("Name", string);
                    this.putValue("help", HelpUtil.ht("/Action/OpenRecent"));
                    this.putValue("toolbar", Boolean.FALSE);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = new File(string);
                    OpenFileAction.OpenFileTask openFileTask = new OpenFileAction.OpenFileTask(Collections.singletonList(file), null);
                    openFileTask.setRecordHistory(true);
                    Main.worker.submit(openFileTask);
                }
            });
        }
        this.add(new JSeparator());
        if (this.clearAction == null) {
            this.clearAction = new ClearAction();
        }
        JMenuItem jMenuItem = new JMenuItem(this.clearAction);
        jMenuItem.setEnabled(!collection.isEmpty());
        this.add(jMenuItem);
    }

    private static class ClearAction
    extends AbstractAction {
        ClearAction() {
            super(I18n.tr("Clear", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Clear the list of recently opened files", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Action/OpenRecent"));
            this.putValue("toolbar", "recentlyopenedfiles/clear");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Main.pref.putCollection("file-open.history", null);
        }
    }
}

