/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ImageryAdjustAction;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public abstract class ImageryLayer
extends Layer {
    public static final ColorProperty PROP_FADE_COLOR = new ColorProperty(I18n.marktr("Imagery fade"), Color.white);
    public static final IntegerProperty PROP_FADE_AMOUNT = new IntegerProperty("imagery.fade_amount", 0);
    public static final IntegerProperty PROP_SHARPEN_LEVEL = new IntegerProperty("imagery.sharpen_level", 0);
    private final List<ImageProcessor> imageProcessors = new ArrayList<ImageProcessor>();
    protected final ImageryInfo info;
    protected Icon icon;
    protected double dx;
    protected double dy;
    protected GammaImageProcessor gammaImageProcessor = new GammaImageProcessor();
    private final ImageryAdjustAction adjustAction = new ImageryAdjustAction(this);

    public static Color getFadeColor() {
        return PROP_FADE_COLOR.get();
    }

    public static Color getFadeColorWithAlpha() {
        Color color = PROP_FADE_COLOR.get();
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), PROP_FADE_AMOUNT.get() * 255 / 100);
    }

    public ImageryLayer(ImageryInfo imageryInfo) {
        super(imageryInfo.getName());
        this.info = imageryInfo;
        if (imageryInfo.getIcon() != null) {
            this.icon = new ImageProvider(imageryInfo.getIcon()).setOptional(true).setMaxHeight(16).setMaxWidth(16).get();
        }
        if (this.icon == null) {
            this.icon = ImageProvider.get("imagery_small");
        }
        this.addImageProcessor(this.createSharpener(PROP_SHARPEN_LEVEL.get()));
        this.addImageProcessor(this.gammaImageProcessor);
    }

    public double getPPD() {
        if (!Main.isDisplayingMapView()) {
            return Main.getProjection().getDefaultZoomInPPD();
        }
        ProjectionBounds projectionBounds = Main.map.mapView.getProjectionBounds();
        return (double)Main.map.mapView.getWidth() / (projectionBounds.maxEast - projectionBounds.minEast);
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setOffset(double d, double d2) {
        this.dx = d;
        this.dy = d2;
    }

    public void displace(double d, double d2) {
        this.setOffset(this.dx += d, this.dy += d2);
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isMergable(Layer layer) {
        return false;
    }

    @Override
    public void mergeFrom(Layer layer) {
    }

    @Override
    public Object getInfoComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(this.getToolTipText()), GBC.eol());
        if (this.info != null) {
            String string = this.info.getUrl();
            if (string != null) {
                jPanel.add((Component)new JLabel(I18n.tr("URL: ", new Object[0])), GBC.std().insets(0, 5, 2, 0));
                jPanel.add((Component)new UrlLabel(string), GBC.eol().insets(2, 5, 10, 0));
            }
            if (this.dx != 0.0 || this.dy != 0.0) {
                jPanel.add((Component)new JLabel(I18n.tr("Offset: ", new Object[0]) + this.dx + ';' + this.dy), GBC.eol().insets(0, 5, 10, 0));
            }
        }
        return jPanel;
    }

    public static ImageryLayer create(ImageryInfo imageryInfo) {
        switch (imageryInfo.getImageryType()) {
            case WMS: 
            case HTML: {
                return new WMSLayer(imageryInfo);
            }
            case WMTS: {
                return new WMTSLayer(imageryInfo);
            }
            case TMS: 
            case BING: 
            case SCANEX: {
                return new TMSLayer(imageryInfo);
            }
        }
        throw new AssertionError((Object)I18n.tr("Unsupported imagery type: {0}", new Object[]{imageryInfo.getImageryType()}));
    }

    public JMenuItem getOffsetMenuItem() {
        JMenu jMenu = new JMenu(I18n.trc("layer", "Offset"));
        jMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        return (JMenuItem)this.getOffsetMenuItem(jMenu);
    }

    public JComponent getOffsetMenuItem(JComponent jComponent) {
        JMenuItem jMenuItem = new JMenuItem(this.adjustAction);
        if (OffsetBookmark.allBookmarks.isEmpty()) {
            return jMenuItem;
        }
        jComponent.add(jMenuItem);
        jComponent.add(new JSeparator());
        boolean bl = false;
        int n = 0;
        for (OffsetBookmark offsetBookmark : OffsetBookmark.allBookmarks) {
            if (!offsetBookmark.isUsable(this)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ApplyOffsetAction(offsetBookmark));
            if (Utils.equalsEpsilon(offsetBookmark.dx, this.dx) && Utils.equalsEpsilon(offsetBookmark.dy, this.dy)) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jComponent.add(jCheckBoxMenuItem);
            n = jCheckBoxMenuItem.getPreferredSize().height;
            bl = true;
        }
        if (n > 0) {
            if (jComponent instanceof JMenu) {
                MenuScroller.setScrollerFor((JMenu)jComponent);
            } else if (jComponent instanceof JPopupMenu) {
                MenuScroller.setScrollerFor((JPopupMenu)jComponent);
            }
        }
        return bl ? jComponent : jMenuItem;
    }

    public ImageProcessor createSharpener(int n) {
        Kernel kernel;
        if (n == 1) {
            kernel = new Kernel(3, 3, new float[]{-0.25f, -0.5f, -0.25f, -0.5f, 4.0f, -0.5f, -0.25f, -0.5f, -0.25f});
        } else if (n == 2) {
            kernel = new Kernel(3, 3, new float[]{-0.5f, -1.0f, -0.5f, -1.0f, 7.0f, -1.0f, -0.5f, -1.0f, -0.5f});
        } else {
            return null;
        }
        ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
        return ImageryLayer.createImageProcessor(convolveOp, false);
    }

    public double getGamma() {
        return this.gammaImageProcessor.getGamma();
    }

    public void setGamma(double d) {
        this.gammaImageProcessor.setGamma(d);
    }

    public boolean addImageProcessor(ImageProcessor imageProcessor) {
        return imageProcessor != null && this.imageProcessors.add(imageProcessor);
    }

    public boolean removeImageProcessor(ImageProcessor imageProcessor) {
        return this.imageProcessors.remove(imageProcessor);
    }

    public static ImageProcessor createImageProcessor(final BufferedImageOp bufferedImageOp, final boolean bl) {
        return new ImageProcessor(){

            @Override
            public BufferedImage process(BufferedImage bufferedImage) {
                return bufferedImageOp.filter(bufferedImage, bl ? bufferedImage : null);
            }
        };
    }

    public List<ImageProcessor> getImageProcessors() {
        return this.imageProcessors;
    }

    public BufferedImage applyImageProcessors(BufferedImage bufferedImage) {
        for (ImageProcessor imageProcessor : this.imageProcessors) {
            bufferedImage = imageProcessor.process(bufferedImage);
        }
        return bufferedImage;
    }

    public void drawErrorTile(BufferedImage bufferedImage, String string) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.RED);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setFont(graphics2D.getFont().deriveFont(0).deriveFont(24.0f));
        graphics2D.setColor(Color.BLACK);
        String string2 = I18n.tr("ERROR", new Object[0]);
        graphics2D.drawString(string2, (bufferedImage.getWidth() - graphics2D.getFontMetrics().stringWidth(string2)) / 2, graphics2D.getFontMetrics().getHeight() + 5);
        if (string != null) {
            float f = 2.5f * (float)graphics2D.getFontMetrics().getHeight() + 10.0f;
            if (!string.contains(" ")) {
                graphics2D.setFont(graphics2D.getFont().deriveFont(0).deriveFont(18.0f));
                graphics2D.drawString(string, 5, (int)f);
            } else {
                HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
                hashMap.put(TextAttribute.FAMILY, "Serif");
                hashMap.put(TextAttribute.SIZE, new Float(18.0));
                AttributedString attributedString = new AttributedString(string, hashMap);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                int n = attributedCharacterIterator.getBeginIndex();
                int n2 = attributedCharacterIterator.getEndIndex();
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f2 = bufferedImage.getWidth() - 10;
                lineBreakMeasurer.setPosition(n);
                while (lineBreakMeasurer.getPosition() < n2) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f2);
                    float f3 = textLayout.isLeftToRight() ? 0.0f : f2 - textLayout.getAdvance();
                    textLayout.draw(graphics2D, f3, f += textLayout.getAscent());
                    f += textLayout.getDescent() + textLayout.getLeading();
                }
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.adjustAction.destroy();
    }

    public static class GammaImageProcessor
    implements ImageProcessor {
        private double gamma = 1.0;
        final short[] gammaChange = new short[256];
        private LookupOp op3 = new LookupOp(new ShortLookupTable(0, new short[][]{this.gammaChange, this.gammaChange, this.gammaChange}), null);
        private LookupOp op4 = new LookupOp(new ShortLookupTable(0, new short[][]{this.gammaChange, this.gammaChange, this.gammaChange, this.gammaChange}), null);

        public double getGamma() {
            return this.gamma;
        }

        public void setGamma(double d) {
            this.gamma = d;
            for (int i = 0; i < 256; ++i) {
                this.gammaChange[i] = (short)(255.0 * Math.pow((double)i / 255.0, d));
            }
        }

        @Override
        public BufferedImage process(BufferedImage bufferedImage) {
            int n;
            block5: {
                if (this.gamma == 1.0) {
                    return bufferedImage;
                }
                try {
                    n = bufferedImage.getRaster().getNumBands();
                    if (bufferedImage.getType() != 0 && n == 3) {
                        return this.op3.filter(bufferedImage, null);
                    }
                    if (bufferedImage.getType() != 0 && n == 4) {
                        return this.op4.filter(bufferedImage, null);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!Main.isTraceEnabled()) break block5;
                    Main.trace(illegalArgumentException.getMessage());
                }
            }
            n = bufferedImage.getTransparency() == 1 ? 1 : 2;
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
            return this.process(bufferedImage2);
        }
    }

    public class OffsetAction
    extends AbstractAction
    implements Layer.LayerAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public Component createMenuComponent() {
            return ImageryLayer.this.getOffsetMenuItem();
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return false;
        }
    }

    class ApplyOffsetAction
    extends AbstractAction {
        private transient OffsetBookmark b;

        ApplyOffsetAction(OffsetBookmark offsetBookmark) {
            super(offsetBookmark.name);
            this.b = offsetBookmark;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayer.this.setOffset(this.b.dx, this.b.dy);
            Main.main.menu.imageryMenu.refreshOffsetMenu();
            Main.map.repaint();
        }
    }
}

