/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.map;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.gui.preferences.SourceType;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TaggingPresetPreference
implements SubPreferenceSetting {
    private static final List<SourceProvider> presetSourceProviders = new ArrayList<SourceProvider>();
    private SourceEditor sources;
    private JCheckBox sortMenu;
    private final PreferenceTabbedPane.ValidationListener validationListener = new TaggingPresetValidationListener();

    private TaggingPresetPreference() {
    }

    public static boolean registerSourceProvider(SourceProvider sourceProvider) {
        if (sourceProvider != null) {
            return presetSourceProviders.add(sourceProvider);
        }
        return false;
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu", new Object[0]), Main.pref.getBoolean("taggingpreset.sortmenu", false));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.sortMenu, GBC.eol().insets(5, 5, 5, 0));
        this.sources = new TaggingPresetSourceEditor();
        jPanel.add((Component)this.sources, GBC.eol().fill(1));
        MapPreference mapPreference = preferenceTabbedPane.getMapPreference();
        mapPreference.addSubTab(this, I18n.tr("Tagging Presets", new Object[0]), jPanel);
        this.sources.deferLoading(mapPreference, jPanel);
        preferenceTabbedPane.addValidationListener(this.validationListener);
    }

    @Override
    public boolean ok() {
        boolean bl = Main.pref.put("taggingpreset.sortmenu", this.sortMenu.getSelectedObjects() != null);
        return bl |= this.sources.finish();
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getMapPreference();
    }

    public static class PresetPrefHelper
    extends SourceEditor.SourcePrefHelper {
        public static final PresetPrefHelper INSTANCE = new PresetPrefHelper();

        public PresetPrefHelper() {
            super("taggingpreset.entries");
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            SourceEditor.ExtendedSourceEntry extendedSourceEntry = new SourceEditor.ExtendedSourceEntry("defaultpresets.xml", "resource://data/defaultpresets.xml");
            extendedSourceEntry.title = I18n.tr("Internal Preset", new Object[0]);
            extendedSourceEntry.description = I18n.tr("The default preset for JOSM", new Object[0]);
            return Collections.singletonList(extendedSourceEntry);
        }

        @Override
        public Map<String, String> serialize(SourceEntry sourceEntry) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("url", sourceEntry.url);
            hashMap.put("title", sourceEntry.title == null ? "" : sourceEntry.title);
            return hashMap;
        }

        @Override
        public SourceEntry deserialize(Map<String, String> map) {
            return new SourceEntry(map.get("url"), null, map.get("title"), true);
        }
    }

    static class TaggingPresetSourceEditor
    extends SourceEditor {
        private static final String iconpref = "taggingpreset.icon.sources";

        TaggingPresetSourceEditor() {
            super(SourceType.TAGGING_PRESET, Main.getJOSMWebsite() + "/presets", presetSourceProviders, true);
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return PresetPrefHelper.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            List<SourceEntry> list = this.activeSourcesModel.getSources();
            boolean bl = PresetPrefHelper.INSTANCE.put(list);
            if (this.tblIconPaths != null) {
                List<String> list2 = this.iconPathsModel.getIconPaths();
                if (!list2.isEmpty()) {
                    if (Main.pref.putCollection(iconpref, list2)) {
                        bl = true;
                    }
                } else if (Main.pref.putCollection(iconpref, null)) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            return PresetPrefHelper.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return Main.pref.getCollection(iconpref, null);
        }

        @Override
        public String getStr(SourceEditor.I18nString i18nString) {
            switch (i18nString) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available presets:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active presets:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new preset by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New preset entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected presets from the list of active presets", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active preset", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available presets to the list of active presets", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available presets from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading preset sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of preset sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Presets#FailedToLoadPresetSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in preset list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new TaggingPresetPreference();
        }
    }

    private final class TaggingPresetValidationListener
    implements PreferenceTabbedPane.ValidationListener {
        private TaggingPresetValidationListener() {
        }

        @Override
        public boolean validatePreferences() {
            if (TaggingPresetPreference.this.sources.hasActiveSourcesChanged()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int n = -1;
                block15: for (SourceEntry sourceEntry : TaggingPresetPreference.this.sources.getActiveSources()) {
                    boolean bl;
                    block17: {
                        ++n;
                        bl = false;
                        try {
                            TaggingPresetReader.readAll(sourceEntry.url, false);
                            bl = true;
                        }
                        catch (IOException iOException) {
                            Main.warn(I18n.tr("Could not read tagging preset source: {0}", sourceEntry));
                            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Error", new Object[0]), new String[]{I18n.tr("Yes", new Object[0]), I18n.tr("No", new Object[0]), I18n.tr("Cancel", new Object[0])});
                            extendedDialog.setContent(I18n.tr("Could not read tagging preset source: {0}\nDo you want to keep it?", sourceEntry));
                            switch (extendedDialog.showDialog().getValue()) {
                                case 1: {
                                    continue block15;
                                }
                                case 2: {
                                    arrayList.add(n);
                                    continue block15;
                                }
                            }
                            return false;
                        }
                        catch (SAXException sAXException) {
                            if (!Main.isTraceEnabled()) break block17;
                            Main.trace(sAXException.getMessage());
                        }
                    }
                    String string = null;
                    try {
                        TaggingPresetReader.readAll(sourceEntry.url, true);
                    }
                    catch (IOException iOException) {
                        String string2 = I18n.tr("Could not read tagging preset source {0}", sourceEntry);
                        Main.error(string2);
                        JOptionPane.showMessageDialog(Main.parent, string2);
                        return false;
                    }
                    catch (SAXParseException sAXParseException) {
                        string = bl ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: [{1}:{2}] {3}</table></html>", sourceEntry, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=400>Error is: [{1}:{2}] {3}</table></html>", sourceEntry, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
                    }
                    catch (SAXException sAXException) {
                        string = bl ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", sourceEntry, sAXException.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", sourceEntry, sAXException.getMessage());
                    }
                    if (string == null) continue;
                    Main.error(string);
                    int n2 = JOptionPane.showConfirmDialog(Main.parent, new JLabel(string), I18n.tr("Error", new Object[0]), 1, 0);
                    switch (n2) {
                        case 0: {
                            continue block15;
                        }
                        case 1: {
                            arrayList.add(n);
                            continue block15;
                        }
                    }
                    return false;
                }
                TaggingPresetPreference.this.sources.removeSources(arrayList);
                return true;
            }
            return true;
        }
    }
}

