/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.date;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class DateUtils {
    public static final BooleanProperty PROP_ISO_DATES = new BooleanProperty("iso.dates", false);
    private static GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private static final DatatypeFactory XML_DATE;

    private DateUtils() {
    }

    public static synchronized Date fromString(String string) {
        return new Date(DateUtils.tsFromString(string));
    }

    public static synchronized long tsFromString(String string) {
        if (DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xxZ") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx") || DateUtils.checkLayout(string, "xxxx-xx-xx xx:xx:xx UTC") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx+xx:00") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx-xx:00")) {
            calendar.set(DateUtils.parsePart4(string, 0), DateUtils.parsePart2(string, 5) - 1, DateUtils.parsePart2(string, 8), DateUtils.parsePart2(string, 11), DateUtils.parsePart2(string, 14), DateUtils.parsePart2(string, 17));
            if (string.length() == 25) {
                int n = DateUtils.parsePart2(string, 20);
                int n2 = string.charAt(19) == '+' ? -3600000 : 3600000;
                return calendar.getTimeInMillis() + (long)(n * n2);
            }
            return calendar.getTimeInMillis();
        }
        if (DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxxZ") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx+xx:00") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx-xx:00")) {
            calendar.set(DateUtils.parsePart4(string, 0), DateUtils.parsePart2(string, 5) - 1, DateUtils.parsePart2(string, 8), DateUtils.parsePart2(string, 11), DateUtils.parsePart2(string, 14), DateUtils.parsePart2(string, 17));
            long l = DateUtils.parsePart3(string, 20);
            if (string.length() == 29) {
                l += (long)(DateUtils.parsePart2(string, 24) * (string.charAt(23) == '+' ? -3600000 : 3600000));
            }
            return calendar.getTimeInMillis() + l;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss");
        Date date = simpleDateFormat.parse(string, new ParsePosition(0));
        if (date != null) {
            return date.getTime();
        }
        try {
            return XML_DATE.newXMLGregorianCalendar(string).toGregorianCalendar().getTimeInMillis();
        }
        catch (Exception exception) {
            return System.currentTimeMillis();
        }
    }

    private static String toXmlFormat(GregorianCalendar gregorianCalendar) {
        XMLGregorianCalendar xMLGregorianCalendar = XML_DATE.newXMLGregorianCalendar(gregorianCalendar);
        if (gregorianCalendar.get(14) == 0) {
            xMLGregorianCalendar.setFractionalSecond(null);
        }
        return xMLGregorianCalendar.toXMLFormat();
    }

    public static synchronized String fromTimestamp(int n) {
        calendar.setTimeInMillis((long)n * 1000L);
        return DateUtils.toXmlFormat(calendar);
    }

    public static synchronized String fromDate(Date date) {
        calendar.setTime(date);
        return DateUtils.toXmlFormat(calendar);
    }

    private static boolean checkLayout(String string, String string2) {
        if (string.length() != string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            char c2 = string.charAt(i);
            if (c == 'x' && c2 >= '0' && c2 <= '9' || c != 'x' && c == c2) continue;
            return false;
        }
        return true;
    }

    private static int num(char c) {
        return c - 48;
    }

    private static int parsePart2(String string, int n) {
        return 10 * DateUtils.num(string.charAt(n)) + DateUtils.num(string.charAt(n + 1));
    }

    private static int parsePart3(String string, int n) {
        return 100 * DateUtils.num(string.charAt(n)) + 10 * DateUtils.num(string.charAt(n + 1)) + DateUtils.num(string.charAt(n + 2));
    }

    private static int parsePart4(String string, int n) {
        return 1000 * DateUtils.num(string.charAt(n)) + 100 * DateUtils.num(string.charAt(n + 1)) + 10 * DateUtils.num(string.charAt(n + 2)) + DateUtils.num(string.charAt(n + 3));
    }

    public static SimpleDateFormat newIsoDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static SimpleDateFormat newIsoDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    }

    public static SimpleDateFormat newOsmApiDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
    }

    public static DateFormat getDateFormat(int n) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return DateUtils.newIsoDateFormat();
        }
        return DateFormat.getDateInstance(n, Locale.getDefault());
    }

    public static String formatDate(Date date, int n) {
        CheckParameterUtil.ensureParameterNotNull(date, "date");
        return DateUtils.getDateFormat(n).format(date);
    }

    public static DateFormat getTimeFormat(int n) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("HH:mm:ss");
        }
        return DateFormat.getTimeInstance(n, Locale.getDefault());
    }

    public static String formatTime(Date date, int n) {
        CheckParameterUtil.ensureParameterNotNull(date, "time");
        return DateUtils.getTimeFormat(n).format(date);
    }

    public static DateFormat getDateTimeFormat(int n, int n2) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return DateFormat.getDateTimeInstance(n, n2, Locale.getDefault());
    }

    public static String formatDateTime(Date date, int n, int n2) {
        CheckParameterUtil.ensureParameterNotNull(date, "datetime");
        return DateUtils.getDateTimeFormat(n, n2).format(date);
    }

    static {
        calendar.setTimeInMillis(0L);
        DatatypeFactory datatypeFactory = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            Main.error(datatypeConfigurationException);
        }
        XML_DATE = datatypeFactory;
    }
}

