/*
 * Decompiled with CFR 0.152.
 */
package com.boundary.high_scale_lib;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.cliffc.high_scale_lib.LongIterator;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;

public class NonBlockingHashSetLong
extends AbstractSet<Long>
implements Serializable {
    private static final Object V = "";
    private final NonBlockingHashMapLong<Object> _map = new NonBlockingHashMapLong();

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        if (!NonBlockingHashSetLong.class.equals(c.getClass())) {
            return super.addAll(c);
        }
        boolean modified = false;
        LongIterator it = ((NonBlockingHashSetLong)c).longIterator();
        while (it.hasNext()) {
            modified |= this.add(it.nextLong());
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!NonBlockingHashSetLong.class.equals(c.getClass())) {
            return super.removeAll(c);
        }
        boolean modified = false;
        LongIterator it = ((NonBlockingHashSetLong)c).longIterator();
        while (it.hasNext()) {
            modified |= this.remove(it.nextLong());
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!NonBlockingHashSetLong.class.equals(c.getClass())) {
            return super.containsAll(c);
        }
        LongIterator it = ((NonBlockingHashSetLong)c).longIterator();
        while (it.hasNext()) {
            if (this.contains(it.nextLong())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!NonBlockingHashSetLong.class.equals(c.getClass())) {
            return super.retainAll(c);
        }
        boolean modified = false;
        NonBlockingHashSetLong nonBlockingHashSetLong = (NonBlockingHashSetLong)c;
        LongIterator it = this.longIterator();
        while (it.hasNext()) {
            if (nonBlockingHashSetLong.contains(it.nextLong())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        LongIterator it = this.longIterator();
        while (it.hasNext()) {
            long value2 = it.nextLong();
            hashCode += (int)(value2 ^ value2 >>> 32);
        }
        return hashCode;
    }

    @Override
    public boolean add(long o) {
        return this._map.putIfAbsent(o, V) != V;
    }

    @Override
    public boolean add(Long o) {
        return this._map.putIfAbsent((long)o, V) != V;
    }

    public boolean contains(long o) {
        return this._map.containsKey(o);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Long && this.contains((Long)o);
    }

    public boolean remove(long o) {
        return this._map.remove(o) == V;
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof Long && this.remove((Long)o);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public String toString() {
        LongIterator it = this.longIterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder().append('[');
        while (true) {
            sb.append(it.next());
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public Iterator<Long> iterator() {
        return this._map.keySet().iterator();
    }

    public LongIterator longIterator() {
        return (LongIterator)this._map.keySet().iterator();
    }

    public void readOnly() {
        throw new RuntimeException("Unimplemented");
    }
}

