/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.DefNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

public class IterNode
extends Node
implements DefNode {
    private final Node varNode;
    private final Node bodyNode;
    private StaticScope scope;

    public IterNode(ISourcePosition position, Node args2, StaticScope scope, Node body) {
        super(position, args2 != null && args2.containsVariableAssignment || body != null && body.containsVariableAssignment);
        this.varNode = args2;
        this.scope = scope;
        this.bodyNode = body;
    }

    public IterNode(ISourcePosition position, ArgsNode args2, Node body, StaticScope scope) {
        super(position, args2 != null && args2.containsVariableAssignment || body != null && body.containsVariableAssignment);
        this.varNode = args2;
        this.bodyNode = body;
        this.scope = scope;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ITERNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    @Override
    public ArgsNode getArgsNode() {
        return (ArgsNode)this.varNode;
    }

    @Override
    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }
}

