/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.CodegenUtils;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final Logger LOG = LoggerFactory.getLogger("InvocationMethodFactory");
    private static final boolean DEBUG = false;
    private static final String COMPILED_CALL_SIG = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class));
    private static final String COMPILED_CALL_SIG_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    private static final String COMPILED_CALL_SIG_ONE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_ONE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_TWO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_TWO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_THREE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_THREE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
    private static final String JAVA_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class));
    public static final int THIS_INDEX = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int RECEIVER_INDEX = 2;
    public static final int CLASS_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int BLOCK_INDEX = 6;
    protected final ClassDefiningJRubyClassLoader classLoader;
    protected final Object syncObject;
    private boolean seenUndefinedClasses = false;
    private boolean haveWarnedUser = false;

    public InvocationMethodFactory(ClassLoader classLoader) {
        this.syncObject = classLoader;
        this.classLoader = classLoader instanceof ClassDefiningJRubyClassLoader ? (ClassDefiningJRubyClassLoader)classLoader : new ClassDefiningJRubyClassLoader(classLoader);
    }

    protected boolean safeFixedSignature(Signature signature) {
        return signature.isFixed() && signature.required() <= 3;
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs) {
        JavaMethodDescriptor desc1 = descs.get(0);
        JRubyMethod anno = desc1.anno;
        String javaMethodName = desc1.name;
        try {
            Class c = this.getAnnotatedMethodClass(descs);
            DescriptorInfo info = new DescriptorInfo(descs);
            JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{implementationClass, desc1.anno.visibility()});
            TypePopulator.populateMethod(ic, Arity.optional().getValue(), javaMethodName, desc1.isStatic, desc1.anno.notImplemented(), desc1.getDeclaringClass(), desc1.name, desc1.getReturnClass(), desc1.getParameterClasses());
            return ic;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnnotatedMethodClass(List<JavaMethodDescriptor> descs) throws Exception {
        JavaMethodDescriptor desc1 = descs.get(0);
        if (!Modifier.isPublic(desc1.getDeclaringClass().getModifiers())) {
            LOG.warn("warning: binding non-public class {}; reflected handles won't work", desc1.declaringClassName);
        }
        String javaMethodName = desc1.name;
        String generatedClassName = CodegenUtils.getAnnotatedBindingClassName(javaMethodName, (CharSequence)desc1.declaringClassName, desc1.isStatic, desc1.actualRequired, desc1.optional, descs.size() > 1, desc1.anno.frame());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            generatedClassName = generatedClassName + "_DBG";
        }
        String generatedClassPath = generatedClassName.replace('.', '/');
        DescriptorInfo info = new DescriptorInfo(descs);
        Class superclass2 = this.determineSuperclass(info);
        Class c = this.tryClass(generatedClassName, desc1.getDeclaringClass(), superclass2);
        if (c == null) {
            Object object = this.syncObject;
            synchronized (object) {
                c = this.tryClass(generatedClassName, desc1.getDeclaringClass(), superclass2);
                if (c == null) {
                    String superClassString = CodegenUtils.p(superclass2);
                    ClassWriter cw = this.createJavaMethodCtor(generatedClassPath, superClassString, info.getParameterDesc());
                    this.addAnnotatedMethodInvoker(cw, "call", superClassString, descs);
                    c = this.endClass(cw, generatedClassName);
                }
            }
        }
        return c;
    }

    private Class determineSuperclass(DescriptorInfo info) {
        Class<Object> superClass = info.getMin() == -1 ? (info.isBlock() ? JavaMethod.JavaMethodNBlock.class : JavaMethod.JavaMethodN.class) : (info.isRest() ? (info.isBlock() ? JavaMethod.BLOCK_REST_METHODS[info.getMin()][info.getMax()] : JavaMethod.REST_METHODS[info.getMin()][info.getMax()]) : (info.isBlock() ? JavaMethod.BLOCK_METHODS[info.getMin()][info.getMax()] : JavaMethod.METHODS[info.getMin()][info.getMax()]));
        if (superClass == null) {
            throw new RuntimeException("invalid multi combination");
        }
        return superClass;
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        String javaMethodName = desc.name;
        try {
            Class c = this.getAnnotatedMethodClass(Arrays.asList(desc));
            JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{implementationClass, desc.anno.visibility()});
            TypePopulator.populateMethod(ic, Arity.fromAnnotation(desc.anno, desc.actualRequired).getValue(), javaMethodName, desc.isStatic, desc.anno.notImplemented(), desc.getDeclaringClass(), desc.name, desc.getReturnClass(), desc.getParameterClasses());
            return ic;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    private void checkArity(JRubyMethod jrubyMethod, SkinnyMethodAdapter method, int specificArity) {
        Label arityError = new Label();
        Label noArityError = new Label();
        switch (specificArity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        boolean checkArity = false;
        if (jrubyMethod.rest()) {
            if (jrubyMethod.required() > 0) {
                method.aload(5);
                method.arraylength();
                method.ldc(jrubyMethod.required());
                method.if_icmplt(arityError);
                checkArity = true;
            }
        } else if (jrubyMethod.optional() > 0) {
            if (jrubyMethod.required() > 0) {
                method.aload(5);
                method.arraylength();
                method.ldc(jrubyMethod.required());
                method.if_icmplt(arityError);
            }
            method.aload(5);
            method.arraylength();
            method.ldc(jrubyMethod.required() + jrubyMethod.optional());
            method.if_icmpgt(arityError);
            checkArity = true;
        } else {
            method.aload(5);
            method.arraylength();
            method.ldc(jrubyMethod.required());
            method.if_icmpne(arityError);
            checkArity = true;
        }
        if (checkArity) {
            method.go_to(noArityError);
            method.label(arityError);
            method.aload(1);
            method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            method.aload(5);
            method.ldc(jrubyMethod.required());
            method.ldc(jrubyMethod.required() + jrubyMethod.optional());
            method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
            method.pop();
            method.label(noArityError);
        }
    }

    private ClassWriter createJavaMethodCtor(String namePath, String sup, String parameterDesc) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        String sourceFile = namePath.substring(namePath.lastIndexOf(47) + 1) + ".gen";
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, sup, null);
        cw.visitSource(sourceFile, null);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw, 1, "<init>", JAVA_SUPER_SIG, null, null);
        mv.start();
        mv.aloadMany(0, 1, 2);
        mv.visitMethodInsn(183, sup, "<init>", JAVA_SUPER_SIG);
        mv.aload(0);
        mv.ldc(parameterDesc);
        mv.invokevirtual(CodegenUtils.p(JavaMethod.class), "setParameterDesc", CodegenUtils.sig(Void.TYPE, String.class));
        mv.voidreturn();
        mv.end();
        return cw;
    }

    private void invokeCallConfigPre(SkinnyMethodAdapter mv, String superClass, int specificArity, boolean block, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        this.prepareForPre(mv, specificArity, block, callConfig);
        mv.invokevirtual(superClass, this.getPreMethod(callConfig), this.getPreSignature(callConfig));
    }

    private void invokeCallConfigPost(SkinnyMethodAdapter mv, String superClass, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        mv.aload(1);
        mv.invokestatic(superClass, InvocationMethodFactory.getPostMethod(callConfig), CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
    }

    private void prepareForPre(SkinnyMethodAdapter mv, int specificArity, boolean block, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        mv.aloadMany(0, 1);
        switch (callConfig.framing()) {
            case Full: {
                mv.aloadMany(2, 4);
                this.loadBlockForPre(mv, specificArity, block);
                break;
            }
            case Backtrace: {
                mv.aload(4);
                break;
            }
            case None: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown call configuration");
            }
        }
    }

    private String getPreMethod(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return "preFrameAndScope";
            }
            case FrameFullScopeDummy: {
                return "preFrameAndDummyScope";
            }
            case FrameFullScopeNone: {
                return "preFrameOnly";
            }
            case FrameBacktraceScopeFull: {
                return "preBacktraceAndScope";
            }
            case FrameBacktraceScopeDummy: {
                return "preBacktraceDummyScope";
            }
            case FrameBacktraceScopeNone: {
                return "preBacktraceOnly";
            }
            case FrameNoneScopeFull: {
                return "preScopeOnly";
            }
            case FrameNoneScopeDummy: {
                return "preNoFrameDummyScope";
            }
            case FrameNoneScopeNone: {
                return "preNoop";
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    private String getPreSignature(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class));
            }
            case FrameFullScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class));
            }
            case FrameFullScopeNone: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class));
            }
            case FrameBacktraceScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameBacktraceScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameBacktraceScopeNone: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameNoneScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class));
            }
            case FrameNoneScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class));
            }
            case FrameNoneScopeNone: {
                return CodegenUtils.sig(Void.TYPE, new Class[0]);
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    public static String getPostMethod(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return "postFrameAndScope";
            }
            case FrameFullScopeDummy: {
                return "postFrameAndScope";
            }
            case FrameFullScopeNone: {
                return "postFrameOnly";
            }
            case FrameBacktraceScopeFull: {
                return "postBacktraceAndScope";
            }
            case FrameBacktraceScopeDummy: {
                return "postBacktraceDummyScope";
            }
            case FrameBacktraceScopeNone: {
                return "postBacktraceOnly";
            }
            case FrameNoneScopeFull: {
                return "postScopeOnly";
            }
            case FrameNoneScopeDummy: {
                return "postNoFrameDummyScope";
            }
            case FrameNoneScopeNone: {
                return "postNoop";
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    private void loadArguments(SkinnyMethodAdapter mv, JavaMethodDescriptor desc, int specificArity) {
        switch (specificArity) {
            default: {
                mv.aload(5);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.loadArgumentWithCast(mv, 1, desc.argumentTypes[0]);
                break;
            }
            case 2: {
                this.loadArgumentWithCast(mv, 1, desc.argumentTypes[0]);
                this.loadArgumentWithCast(mv, 2, desc.argumentTypes[1]);
                break;
            }
            case 3: {
                this.loadArgumentWithCast(mv, 1, desc.argumentTypes[0]);
                this.loadArgumentWithCast(mv, 2, desc.argumentTypes[1]);
                this.loadArgumentWithCast(mv, 3, desc.argumentTypes[2]);
            }
        }
    }

    private void loadArgumentWithCast(SkinnyMethodAdapter mv, int argNumber, Class coerceType) {
        mv.aload(5 + (argNumber - 1));
        if (coerceType != IRubyObject.class && coerceType != IRubyObject[].class) {
            if (coerceType == RubyString.class) {
                mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "convertToString", CodegenUtils.sig(RubyString.class, new Class[0]));
            } else {
                throw new RuntimeException("Unknown coercion target: " + coerceType);
            }
        }
    }

    private void loadBlockForPre(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        if (!getsBlock) {
            mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            return;
        }
        this.loadBlock(mv, specificArity, getsBlock);
    }

    private void loadBlock(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        if (!getsBlock) {
            return;
        }
        switch (specificArity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mv.aload(5 + specificArity);
                break;
            }
            default: {
                mv.aload(6);
            }
        }
    }

    private void loadReceiver(String typePath, JavaMethodDescriptor desc, SkinnyMethodAdapter mv) {
        if (Modifier.isStatic(desc.modifiers)) {
            if (desc.hasContext) {
                mv.aload(1);
            }
            mv.aload(2);
        } else {
            mv.aload(2);
            mv.checkcast(typePath);
            if (desc.hasContext) {
                mv.aload(1);
            }
        }
    }

    private Class tryClass(String name2, Class targetClass, Class expectedSuperclass) {
        Class<?> c;
        try {
            c = this.classLoader == null ? Class.forName(name2, true, this.classLoader) : this.classLoader.loadClass(name2);
        }
        catch (Exception e) {
            this.seenUndefinedClasses = true;
            return null;
        }
        if (c.getSuperclass() == expectedSuperclass) {
            if (this.seenUndefinedClasses && !this.haveWarnedUser) {
                this.haveWarnedUser = true;
                System.err.println("WARNING: while creating new bindings for " + targetClass + ",\n" + "found an existing binding; you may want to run a clean build.");
            }
            return c;
        }
        this.seenUndefinedClasses = true;
        return null;
    }

    protected Class endClass(ClassWriter cw, String name2) {
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        return this.classLoader.defineClass(name2, code);
    }

    private SkinnyMethodAdapter beginMethod(ClassWriter cw, String methodName, int specificArity, boolean block) {
        switch (specificArity) {
            default: {
                if (block) {
                    return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_BLOCK, null, null);
                }
                return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG, null, null);
            }
            case 0: {
                if (block) {
                    return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_ZERO_BLOCK, null, null);
                }
                return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_ZERO, null, null);
            }
            case 1: {
                if (block) {
                    return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_ONE_BLOCK, null, null);
                }
                return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_ONE, null, null);
            }
            case 2: {
                if (block) {
                    return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_TWO_BLOCK, null, null);
                }
                return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_TWO, null, null);
            }
            case 3: 
        }
        if (block) {
            return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_THREE_BLOCK, null, null);
        }
        return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_THREE, null, null);
    }

    private void addAnnotatedMethodInvoker(ClassWriter cw, String callName, String superClass, List<JavaMethodDescriptor> descs) {
        for (JavaMethodDescriptor desc : descs) {
            int specificArity = -1;
            if (desc.optional == 0 && !desc.rest) {
                if (desc.required == 0) {
                    specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                } else if (desc.required >= 0 && desc.required <= 3) {
                    specificArity = desc.required;
                }
            }
            boolean hasBlock = desc.hasBlock;
            SkinnyMethodAdapter mv = null;
            mv = this.beginMethod(cw, callName, specificArity, hasBlock);
            mv.visitCode();
            this.createAnnotatedMethodInvocation(desc, mv, superClass, specificArity, hasBlock);
            mv.end();
        }
    }

    private void createAnnotatedMethodInvocation(JavaMethodDescriptor desc, SkinnyMethodAdapter method, String superClass, int specificArity, boolean block) {
        String typePath = desc.declaringClassPath;
        String javaMethodName = desc.name;
        this.checkArity(desc.anno, method, specificArity);
        CallConfiguration callConfig = CallConfiguration.getCallConfigByAnno(desc.anno);
        if (!callConfig.isNoop()) {
            this.invokeCallConfigPre(method, superClass, specificArity, block, callConfig);
        }
        int traceBoolIndex = -1;
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            switch (specificArity) {
                case -1: {
                    traceBoolIndex = 5 + (block ? 1 : 0) + 1;
                    break;
                }
                case 0: {
                    traceBoolIndex = 5 + (block ? 1 : 0);
                    break;
                }
                default: {
                    traceBoolIndex = 5 + specificArity + (block ? 1 : 0) + 1;
                }
            }
            method.aload(1);
            method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            method.invokevirtual(CodegenUtils.p(Ruby.class), "hasEventHooks", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            method.istore(traceBoolIndex);
            this.invokeCCallTrace(method, traceBoolIndex);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label doFinally = new Label();
        if (!callConfig.isNoop()) {
            method.trycatch(tryBegin, tryEnd, doFinally, null);
        }
        method.label(tryBegin);
        this.loadReceiver(typePath, desc, method);
        this.loadArguments(method, desc, specificArity);
        this.loadBlock(method, specificArity, block);
        if (Modifier.isStatic(desc.modifiers)) {
            method.invokestatic(typePath, javaMethodName, desc.signature);
        } else {
            method.invokevirtual(typePath, javaMethodName, desc.signature);
        }
        if (desc.getReturnClass() == Void.TYPE) {
            method.aload(1);
            method.getfield(CodegenUtils.p(ThreadContext.class), "nil", CodegenUtils.ci(IRubyObject.class));
        }
        method.label(tryEnd);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.invokeCReturnTrace(method, traceBoolIndex);
        }
        if (!callConfig.isNoop()) {
            this.invokeCallConfigPost(method, superClass, callConfig);
        }
        method.visitInsn(176);
        if (!callConfig.isNoop()) {
            method.label(doFinally);
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.invokeCReturnTrace(method, traceBoolIndex);
            }
            if (!callConfig.isNoop()) {
                this.invokeCallConfigPost(method, superClass, callConfig);
            }
            method.athrow();
        }
    }

    private void invokeCCallTrace(SkinnyMethodAdapter method, int traceBoolIndex) {
        method.aloadMany(0, 1);
        method.iload(traceBoolIndex);
        method.aload(4);
        method.invokevirtual(CodegenUtils.p(JavaMethod.class), "callTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Boolean.TYPE, String.class));
    }

    private void invokeCReturnTrace(SkinnyMethodAdapter method, int traceBoolIndex) {
        method.aloadMany(0, 1);
        method.iload(traceBoolIndex);
        method.aload(4);
        method.invokevirtual(CodegenUtils.p(JavaMethod.class), "returnTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Boolean.TYPE, String.class));
    }

    static class DescriptorInfo {
        private int min = Integer.MAX_VALUE;
        private int max = 0;
        private boolean frame = false;
        private boolean scope = false;
        private boolean rest = false;
        private boolean block = false;
        private String parameterDesc;
        private static final boolean RICH_NATIVE_METHOD_PARAMETERS = false;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public DescriptorInfo(List<JavaMethodDescriptor> descs) {
            boolean first2 = true;
            boolean lastBlock = false;
            for (JavaMethodDescriptor desc : descs) {
                if (first2) {
                    first2 = false;
                } else if (lastBlock != desc.hasBlock) {
                    throw new RuntimeException("Mismatched block parameters for method " + desc.declaringClassName + "." + desc.name);
                }
                lastBlock = desc.hasBlock;
                int specificArity = -1;
                if (desc.hasVarArgs) {
                    if (desc.optional == 0 && !desc.rest && desc.required == 0) {
                        throw new RuntimeException("IRubyObject[] args but neither of optional or rest specified for method " + desc.declaringClassName + "." + desc.name);
                    }
                    this.rest = true;
                    if (descs.size() == 1) {
                        this.min = -1;
                    }
                } else {
                    if (desc.optional == 0 && !desc.rest) {
                        if (desc.required == 0) {
                            if (desc.actualRequired > 3) throw new RuntimeException("Invalid specific-arity number of arguments (" + desc.actualRequired + ") on method " + desc.declaringClassName + "." + desc.name);
                            specificArity = desc.actualRequired;
                        } else if (desc.required >= 0 && desc.required <= 3) {
                            if (desc.actualRequired != desc.required) {
                                throw new RuntimeException("Specified required args does not match actual on method " + desc.declaringClassName + "." + desc.name);
                            }
                            specificArity = desc.required;
                        }
                    }
                    if (specificArity < this.min) {
                        this.min = specificArity;
                    }
                    if (specificArity > this.max) {
                        this.max = specificArity;
                    }
                }
                if (this.frame && !desc.anno.frame()) {
                    throw new RuntimeException("Unbalanced frame property on method " + desc.declaringClassName + "." + desc.name);
                }
                if (this.scope && !desc.anno.scope()) {
                    throw new RuntimeException("Unbalanced scope property on method " + desc.declaringClassName + "." + desc.name);
                }
                this.frame |= desc.anno.frame();
                this.scope |= desc.anno.scope();
                this.block |= desc.hasBlock;
            }
            StringBuilder descBuilder = new StringBuilder();
            if (this.min == this.max) {
                for (int i2 = 0; i2 < this.min; ++i2) {
                    if (i2 > 0) {
                        descBuilder.append(';');
                    }
                    descBuilder.append(ArgumentType.REQ);
                }
            } else {
                descBuilder.append(ArgumentType.ANONREST);
            }
            this.parameterDesc = descBuilder.toString();
        }

        @Deprecated
        public boolean isBacktrace() {
            return false;
        }

        public boolean isFrame() {
            return this.frame;
        }

        public int getMax() {
            return this.max;
        }

        public int getMin() {
            return this.min;
        }

        public boolean isScope() {
            return this.scope;
        }

        public boolean isRest() {
            return this.rest;
        }

        public boolean isBlock() {
            return this.block;
        }

        public String getParameterDesc() {
            return this.parameterDesc;
        }
    }
}

