/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.HashMap;
import java.util.Map;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.ir.OpClass;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockNoResultCallInstr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.interpreter.InterpreterEngine;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.opto.ConstantCache;

public class SimpleMethodInterpreterEngine
extends InterpreterEngine {
    public static Map<Operation, Boolean> OPERATIONS = new HashMap(){
        {
            this.put(Operation.RECV_PRE_REQD_ARG, true);
            this.put(Operation.CHECK_ARITY, true);
            this.put(Operation.RETURN, true);
            this.put(Operation.LINE_NUM, true);
            this.put(Operation.RECV_SELF, true);
            this.put(Operation.RECV_JRUBY_EXC, true);
            this.put(Operation.THROW, true);
            this.put(Operation.PUSH_FRAME, true);
            this.put(Operation.POP_FRAME, true);
            this.put(Operation.PUSH_BINDING, true);
            this.put(Operation.POP_BINDING, true);
            this.put(Operation.NORESULT_CALL_1O, true);
            this.put(Operation.SEARCH_CONST, true);
            this.put(Operation.INHERITANCE_SEARCH_CONST, true);
            this.put(Operation.NORESULT_CALL, true);
            this.put(Operation.CALL, true);
            this.put(Operation.CALL_0O, true);
            this.put(Operation.CALL_1O, true);
            this.put(Operation.B_FALSE, true);
            this.put(Operation.B_NIL, true);
            this.put(Operation.BNE, true);
            this.put(Operation.LOAD_IMPLICIT_CLOSURE, true);
            this.put(Operation.COPY, true);
            this.put(Operation.JUMP, true);
            this.put(Operation.RUNTIME_HELPER, true);
            this.put(Operation.GET_FIELD, true);
            this.put(Operation.PUT_FIELD, true);
            this.put(Operation.BUILD_COMPOUND_STRING, true);
            this.put(Operation.CONST_MISSING, true);
        }
    };

    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, Block block, Block.Type blockType) {
        return this.interpret(context, self2, interpreterContext, implClass, name2, (IRubyObject)null, block, blockType);
    }

    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject arg1, Block block, Block.Type blockType) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        boolean debug = IRRuntimeHelpers.isDebug();
        block32: while (ipc < n) {
            Instr instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: {}", instr);
                ++Interpreter.interpInstrsCount;
            }
            try {
                switch (operation) {
                    case RECV_PRE_REQD_ARG: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)arg1);
                        break;
                    }
                    case CHECK_ARITY: {
                        break;
                    }
                    case RETURN: {
                        return (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
                    }
                    case LINE_NUM: {
                        context.setLine(((LineNumberInstr)instr).lineNumber);
                        break;
                    }
                    case RECV_SELF: {
                        break;
                    }
                    case RECV_JRUBY_EXC: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), exception2);
                        break;
                    }
                    case THROW: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case PUSH_FRAME: {
                        context.preMethodFrameOnly(implClass, name2, self2, block);
                        context.setCurrentVisibility(Visibility.PUBLIC);
                        break;
                    }
                    case POP_FRAME: {
                        context.popFrame();
                        break;
                    }
                    case PUSH_BINDING: {
                        currDynScope = interpreterContext.newDynamicScope(context);
                        context.pushScope(currDynScope);
                        break;
                    }
                    case POP_BINDING: {
                        context.popScope();
                        break;
                    }
                    case NORESULT_CALL_1O: {
                        CallBase call2 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        call2.getCallSite().call(context, self2, r, o);
                        break;
                    }
                    case SEARCH_CONST: {
                        SearchConstInstr sci = (SearchConstInstr)instr;
                        ConstantCache cache = sci.getConstantCache();
                        Object result2 = !ConstantCache.isCached(cache) ? sci.cache(context, currScope, currDynScope, self2, temp) : cache.value;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, sci.getResult(), result2);
                        break;
                    }
                    case INHERITANCE_SEARCH_CONST: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case NORESULT_CALL: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case CALL: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, instr, instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case CALL_0O: {
                        CallBase call2 = (ZeroOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CallInstr)call2).getResult(), (Object)call2.getCallSite().call(context, self2, r));
                        break;
                    }
                    case CALL_1O: {
                        CallBase call2 = (OneOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CallInstr)call2).getResult(), (Object)call2.getCallSite().call(context, self2, r, o));
                        break;
                    }
                    case B_NIL: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_FALSE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_TRUE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case BNE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case LOAD_IMPLICIT_CLOSURE: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)block);
                        break;
                    }
                    case COPY: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CopyInstr)instr).getResult(), SimpleMethodInterpreterEngine.retrieveOp(((CopyInstr)instr).getSource(), context, self2, currDynScope, currScope, temp));
                        break;
                    }
                    case JUMP: {
                        ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                        break;
                    }
                    case RUNTIME_HELPER: {
                        RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, blockType));
                        break;
                    }
                    case GET_FIELD: {
                        IRubyObject result3;
                        GetFieldInstr gfi = (GetFieldInstr)instr;
                        IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                        VariableAccessor a = gfi.getAccessor(object);
                        IRubyObject iRubyObject = result3 = a == null ? null : (IRubyObject)a.get(object);
                        if (result3 == null) {
                            if (context.runtime.isVerbose()) {
                                context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + gfi.getRef() + " not initialized");
                            }
                            result3 = context.nil;
                        }
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, gfi.getResult(), (Object)result3);
                        break;
                    }
                    case PUT_FIELD: {
                        PutFieldInstr putField = (PutFieldInstr)instr;
                        IRubyObject object = (IRubyObject)putField.getTarget().retrieve(context, self2, currScope, currDynScope, temp);
                        RubyClass clazz = object.getMetaClass().getRealClass();
                        clazz.getVariableAccessorForWrite(putField.getRef()).set(object, putField.getValue().retrieve(context, self2, currScope, currDynScope, temp));
                        break;
                    }
                    default: {
                        if (instr.getOperation().opClass == OpClass.BRANCH_OP) {
                            ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                            break;
                        }
                        Object result4 = instr.interpret(context, currScope, currDynScope, self2, temp);
                        if (!(instr instanceof ResultInstr)) continue block32;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), result4);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ipc = instr.getRPC();
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject arg1, IRubyObject arg2, Block block, Block.Type blockType) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        boolean debug = IRRuntimeHelpers.isDebug();
        block36: while (ipc < n) {
            Instr instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: {}", instr);
                ++Interpreter.interpInstrsCount;
            }
            try {
                switch (operation) {
                    case RECV_PRE_REQD_ARG: {
                        int argIndex = ((ReceivePreReqdArgInstr)instr).getArgIndex();
                        IRubyObject arg3 = null;
                        switch (argIndex) {
                            case 0: {
                                arg3 = arg1;
                                break;
                            }
                            case 1: {
                                arg3 = arg2;
                            }
                        }
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)arg3);
                        break;
                    }
                    case CHECK_ARITY: {
                        break;
                    }
                    case RETURN: {
                        return (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
                    }
                    case LINE_NUM: {
                        context.setLine(((LineNumberInstr)instr).lineNumber);
                        break;
                    }
                    case RECV_SELF: {
                        break;
                    }
                    case RECV_JRUBY_EXC: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), exception2);
                        break;
                    }
                    case THROW: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case PUSH_FRAME: {
                        context.preMethodFrameOnly(implClass, name2, self2, block);
                        context.setCurrentVisibility(Visibility.PUBLIC);
                        break;
                    }
                    case POP_FRAME: {
                        context.popFrame();
                        break;
                    }
                    case PUSH_BINDING: {
                        currDynScope = interpreterContext.newDynamicScope(context);
                        context.pushScope(currDynScope);
                        break;
                    }
                    case POP_BINDING: {
                        context.popScope();
                        break;
                    }
                    case NORESULT_CALL_1O: {
                        OneOperandArgNoBlockNoResultCallInstr call2 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        call2.getCallSite().call(context, self2, r, o);
                        break;
                    }
                    case SEARCH_CONST: {
                        SearchConstInstr sci = (SearchConstInstr)instr;
                        ConstantCache cache = sci.getConstantCache();
                        Object result2 = !ConstantCache.isCached(cache) ? sci.cache(context, currScope, currDynScope, self2, temp) : cache.value;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, sci.getResult(), result2);
                        break;
                    }
                    case INHERITANCE_SEARCH_CONST: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case NORESULT_CALL: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case CALL: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, instr, instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case CALL_0O: {
                        ZeroOperandArgNoBlockCallInstr call3 = (ZeroOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call3.getReceiver(), context, self2, currDynScope, currScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, call3.getResult(), (Object)call3.getCallSite().call(context, self2, r));
                        break;
                    }
                    case CALL_1O: {
                        OneOperandArgNoBlockCallInstr call4 = (OneOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call4.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call4.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, call4.getResult(), (Object)call4.getCallSite().call(context, self2, r, o));
                        break;
                    }
                    case B_NIL: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_FALSE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_TRUE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case BNE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case LOAD_IMPLICIT_CLOSURE: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)block);
                        break;
                    }
                    case COPY: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CopyInstr)instr).getResult(), SimpleMethodInterpreterEngine.retrieveOp(((CopyInstr)instr).getSource(), context, self2, currDynScope, currScope, temp));
                        break;
                    }
                    case JUMP: {
                        ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                        break;
                    }
                    case RUNTIME_HELPER: {
                        RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, blockType));
                        break;
                    }
                    case GET_FIELD: {
                        IRubyObject result3;
                        GetFieldInstr gfi = (GetFieldInstr)instr;
                        IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                        VariableAccessor a = gfi.getAccessor(object);
                        IRubyObject iRubyObject = result3 = a == null ? null : (IRubyObject)a.get(object);
                        if (result3 == null) {
                            if (context.runtime.isVerbose()) {
                                context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + gfi.getRef() + " not initialized");
                            }
                            result3 = context.nil;
                        }
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, gfi.getResult(), (Object)result3);
                        break;
                    }
                    case PUT_FIELD: {
                        PutFieldInstr putField = (PutFieldInstr)instr;
                        IRubyObject object = (IRubyObject)putField.getTarget().retrieve(context, self2, currScope, currDynScope, temp);
                        RubyClass clazz = object.getMetaClass().getRealClass();
                        clazz.getVariableAccessorForWrite(putField.getRef()).set(object, putField.getValue().retrieve(context, self2, currScope, currDynScope, temp));
                        break;
                    }
                    default: {
                        if (instr.getOperation().opClass == OpClass.BRANCH_OP) {
                            ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                            break;
                        }
                        Object result4 = instr.interpret(context, currScope, currDynScope, self2, temp);
                        if (!(instr instanceof ResultInstr)) continue block36;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), result4);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ipc = instr.getRPC();
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block, Block.Type blockType) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        boolean debug = IRRuntimeHelpers.isDebug();
        block37: while (ipc < n) {
            Instr instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: {}", instr);
                ++Interpreter.interpInstrsCount;
            }
            try {
                switch (operation) {
                    case RECV_PRE_REQD_ARG: {
                        int argIndex = ((ReceivePreReqdArgInstr)instr).getArgIndex();
                        IRubyObject arg4 = null;
                        switch (argIndex) {
                            case 0: {
                                arg4 = arg1;
                                break;
                            }
                            case 1: {
                                arg4 = arg2;
                                break;
                            }
                            case 2: {
                                arg4 = arg3;
                            }
                        }
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)arg4);
                        break;
                    }
                    case CHECK_ARITY: {
                        break;
                    }
                    case RETURN: {
                        return (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
                    }
                    case LINE_NUM: {
                        context.setLine(((LineNumberInstr)instr).lineNumber);
                        break;
                    }
                    case RECV_SELF: {
                        break;
                    }
                    case RECV_JRUBY_EXC: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), exception2);
                        break;
                    }
                    case THROW: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case PUSH_FRAME: {
                        context.preMethodFrameOnly(implClass, name2, self2, block);
                        context.setCurrentVisibility(Visibility.PUBLIC);
                        break;
                    }
                    case POP_FRAME: {
                        context.popFrame();
                        break;
                    }
                    case PUSH_BINDING: {
                        currDynScope = interpreterContext.newDynamicScope(context);
                        context.pushScope(currDynScope);
                        break;
                    }
                    case POP_BINDING: {
                        context.popScope();
                        break;
                    }
                    case NORESULT_CALL_1O: {
                        OneOperandArgNoBlockNoResultCallInstr call2 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        call2.getCallSite().call(context, self2, r, o);
                        break;
                    }
                    case SEARCH_CONST: {
                        SearchConstInstr sci = (SearchConstInstr)instr;
                        ConstantCache cache = sci.getConstantCache();
                        Object result2 = !ConstantCache.isCached(cache) ? sci.cache(context, currScope, currDynScope, self2, temp) : cache.value;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, sci.getResult(), result2);
                        break;
                    }
                    case INHERITANCE_SEARCH_CONST: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case NORESULT_CALL: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case CALL: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, instr, instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case CALL_0O: {
                        ZeroOperandArgNoBlockCallInstr call3 = (ZeroOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call3.getReceiver(), context, self2, currDynScope, currScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, call3.getResult(), (Object)call3.getCallSite().call(context, self2, r));
                        break;
                    }
                    case CALL_1O: {
                        OneOperandArgNoBlockCallInstr call4 = (OneOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call4.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call4.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, call4.getResult(), (Object)call4.getCallSite().call(context, self2, r, o));
                        break;
                    }
                    case B_NIL: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_FALSE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_TRUE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case BNE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case LOAD_IMPLICIT_CLOSURE: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)block);
                        break;
                    }
                    case COPY: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CopyInstr)instr).getResult(), SimpleMethodInterpreterEngine.retrieveOp(((CopyInstr)instr).getSource(), context, self2, currDynScope, currScope, temp));
                        break;
                    }
                    case JUMP: {
                        ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                        break;
                    }
                    case RUNTIME_HELPER: {
                        RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, blockType));
                        break;
                    }
                    case GET_FIELD: {
                        IRubyObject result3;
                        GetFieldInstr gfi = (GetFieldInstr)instr;
                        IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                        VariableAccessor a = gfi.getAccessor(object);
                        IRubyObject iRubyObject = result3 = a == null ? null : (IRubyObject)a.get(object);
                        if (result3 == null) {
                            if (context.runtime.isVerbose()) {
                                context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + gfi.getRef() + " not initialized");
                            }
                            result3 = context.nil;
                        }
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, gfi.getResult(), (Object)result3);
                        break;
                    }
                    case PUT_FIELD: {
                        PutFieldInstr putField = (PutFieldInstr)instr;
                        IRubyObject object = (IRubyObject)putField.getTarget().retrieve(context, self2, currScope, currDynScope, temp);
                        RubyClass clazz = object.getMetaClass().getRealClass();
                        clazz.getVariableAccessorForWrite(putField.getRef()).set(object, putField.getValue().retrieve(context, self2, currScope, currDynScope, temp));
                        break;
                    }
                    default: {
                        if (instr.getOperation().opClass == OpClass.BRANCH_OP) {
                            ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                            break;
                        }
                        Object result4 = instr.interpret(context, currScope, currDynScope, self2, temp);
                        if (!(instr instanceof ResultInstr)) continue block37;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), result4);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ipc = instr.getRPC();
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, Block block, Block.Type blockType) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        boolean debug = IRRuntimeHelpers.isDebug();
        block38: while (ipc < n) {
            Instr instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: {}", instr);
                ++Interpreter.interpInstrsCount;
            }
            try {
                switch (operation) {
                    case RECV_PRE_REQD_ARG: {
                        int argIndex = ((ReceivePreReqdArgInstr)instr).getArgIndex();
                        IRubyObject arg5 = null;
                        switch (argIndex) {
                            case 0: {
                                arg5 = arg1;
                                break;
                            }
                            case 1: {
                                arg5 = arg2;
                                break;
                            }
                            case 2: {
                                arg5 = arg3;
                                break;
                            }
                            case 3: {
                                arg5 = arg4;
                            }
                        }
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)arg5);
                        break;
                    }
                    case CHECK_ARITY: {
                        break;
                    }
                    case RETURN: {
                        return (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
                    }
                    case LINE_NUM: {
                        context.setLine(((LineNumberInstr)instr).lineNumber);
                        break;
                    }
                    case RECV_SELF: {
                        break;
                    }
                    case RECV_JRUBY_EXC: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), exception2);
                        break;
                    }
                    case THROW: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case PUSH_FRAME: {
                        context.preMethodFrameOnly(implClass, name2, self2, block);
                        context.setCurrentVisibility(Visibility.PUBLIC);
                        break;
                    }
                    case POP_FRAME: {
                        context.popFrame();
                        break;
                    }
                    case PUSH_BINDING: {
                        currDynScope = interpreterContext.newDynamicScope(context);
                        context.pushScope(currDynScope);
                        break;
                    }
                    case POP_BINDING: {
                        context.popScope();
                        break;
                    }
                    case NORESULT_CALL_1O: {
                        OneOperandArgNoBlockNoResultCallInstr call2 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        call2.getCallSite().call(context, self2, r, o);
                        break;
                    }
                    case SEARCH_CONST: {
                        SearchConstInstr sci = (SearchConstInstr)instr;
                        ConstantCache cache = sci.getConstantCache();
                        Object result2 = !ConstantCache.isCached(cache) ? sci.cache(context, currScope, currDynScope, self2, temp) : cache.value;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, sci.getResult(), result2);
                        break;
                    }
                    case INHERITANCE_SEARCH_CONST: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case NORESULT_CALL: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case CALL: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, instr, instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case CALL_0O: {
                        ZeroOperandArgNoBlockCallInstr call3 = (ZeroOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call3.getReceiver(), context, self2, currDynScope, currScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, call3.getResult(), (Object)call3.getCallSite().call(context, self2, r));
                        break;
                    }
                    case CALL_1O: {
                        OneOperandArgNoBlockCallInstr call4 = (OneOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call4.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call4.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, call4.getResult(), (Object)call4.getCallSite().call(context, self2, r, o));
                        break;
                    }
                    case B_NIL: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_FALSE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_TRUE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case BNE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case LOAD_IMPLICIT_CLOSURE: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)block);
                        break;
                    }
                    case COPY: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CopyInstr)instr).getResult(), SimpleMethodInterpreterEngine.retrieveOp(((CopyInstr)instr).getSource(), context, self2, currDynScope, currScope, temp));
                        break;
                    }
                    case JUMP: {
                        ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                        break;
                    }
                    case RUNTIME_HELPER: {
                        RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, blockType));
                        break;
                    }
                    case GET_FIELD: {
                        IRubyObject result3;
                        GetFieldInstr gfi = (GetFieldInstr)instr;
                        IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                        VariableAccessor a = gfi.getAccessor(object);
                        IRubyObject iRubyObject = result3 = a == null ? null : (IRubyObject)a.get(object);
                        if (result3 == null) {
                            if (context.runtime.isVerbose()) {
                                context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + gfi.getRef() + " not initialized");
                            }
                            result3 = context.nil;
                        }
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, gfi.getResult(), (Object)result3);
                        break;
                    }
                    case PUT_FIELD: {
                        PutFieldInstr putField = (PutFieldInstr)instr;
                        IRubyObject object = (IRubyObject)putField.getTarget().retrieve(context, self2, currScope, currDynScope, temp);
                        RubyClass clazz = object.getMetaClass().getRealClass();
                        clazz.getVariableAccessorForWrite(putField.getRef()).set(object, putField.getValue().retrieve(context, self2, currScope, currDynScope, temp));
                        break;
                    }
                    default: {
                        if (instr.getOperation().opClass == OpClass.BRANCH_OP) {
                            ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                            break;
                        }
                        Object result4 = instr.interpret(context, currScope, currDynScope, self2, temp);
                        if (!(instr instanceof ResultInstr)) continue block38;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), result4);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ipc = instr.getRPC();
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject[] args2, Block block, Block.Type blockType) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        boolean debug = IRRuntimeHelpers.isDebug();
        block32: while (ipc < n) {
            Instr instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: {}", instr);
                ++Interpreter.interpInstrsCount;
            }
            try {
                switch (operation) {
                    case RECV_PRE_REQD_ARG: {
                        int argIndex = ((ReceivePreReqdArgInstr)instr).getArgIndex();
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)IRRuntimeHelpers.getPreArgSafe(context, args2, argIndex));
                        break;
                    }
                    case CHECK_ARITY: {
                        break;
                    }
                    case RETURN: {
                        return (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
                    }
                    case LINE_NUM: {
                        context.setLine(((LineNumberInstr)instr).lineNumber);
                        break;
                    }
                    case RECV_SELF: {
                        break;
                    }
                    case RECV_JRUBY_EXC: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), exception2);
                        break;
                    }
                    case THROW: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case PUSH_FRAME: {
                        context.preMethodFrameOnly(implClass, name2, self2, block);
                        context.setCurrentVisibility(Visibility.PUBLIC);
                        break;
                    }
                    case POP_FRAME: {
                        context.popFrame();
                        break;
                    }
                    case PUSH_BINDING: {
                        currDynScope = interpreterContext.newDynamicScope(context);
                        context.pushScope(currDynScope);
                        break;
                    }
                    case POP_BINDING: {
                        context.popScope();
                        break;
                    }
                    case NORESULT_CALL_1O: {
                        CallBase call2 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        call2.getCallSite().call(context, self2, r, o);
                        break;
                    }
                    case SEARCH_CONST: {
                        SearchConstInstr sci = (SearchConstInstr)instr;
                        ConstantCache cache = sci.getConstantCache();
                        Object result2 = !ConstantCache.isCached(cache) ? sci.cache(context, currScope, currDynScope, self2, temp) : cache.value;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, sci.getResult(), result2);
                        break;
                    }
                    case INHERITANCE_SEARCH_CONST: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case NORESULT_CALL: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case CALL: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, instr, instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case CALL_0O: {
                        CallBase call2 = (ZeroOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CallInstr)call2).getResult(), (Object)call2.getCallSite().call(context, self2, r));
                        break;
                    }
                    case CALL_1O: {
                        CallBase call2 = (OneOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)SimpleMethodInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CallInstr)call2).getResult(), (Object)call2.getCallSite().call(context, self2, r, o));
                        break;
                    }
                    case B_NIL: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_FALSE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case B_TRUE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case BNE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case LOAD_IMPLICIT_CLOSURE: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)block);
                        break;
                    }
                    case COPY: {
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((CopyInstr)instr).getResult(), SimpleMethodInterpreterEngine.retrieveOp(((CopyInstr)instr).getSource(), context, self2, currDynScope, currScope, temp));
                        break;
                    }
                    case JUMP: {
                        ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                        break;
                    }
                    case RUNTIME_HELPER: {
                        RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, blockType));
                        break;
                    }
                    case GET_FIELD: {
                        IRubyObject result3;
                        GetFieldInstr gfi = (GetFieldInstr)instr;
                        IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                        VariableAccessor a = gfi.getAccessor(object);
                        IRubyObject iRubyObject = result3 = a == null ? null : (IRubyObject)a.get(object);
                        if (result3 == null) {
                            if (context.runtime.isVerbose()) {
                                context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + gfi.getRef() + " not initialized");
                            }
                            result3 = context.nil;
                        }
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, gfi.getResult(), (Object)result3);
                        break;
                    }
                    case PUT_FIELD: {
                        PutFieldInstr putField = (PutFieldInstr)instr;
                        IRubyObject object = (IRubyObject)putField.getTarget().retrieve(context, self2, currScope, currDynScope, temp);
                        RubyClass clazz = object.getMetaClass().getRealClass();
                        clazz.getVariableAccessorForWrite(putField.getRef()).set(object, putField.getValue().retrieve(context, self2, currScope, currDynScope, temp));
                        break;
                    }
                    default: {
                        if (instr.getOperation().opClass == OpClass.BRANCH_OP) {
                            ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                            break;
                        }
                        Object result4 = instr.interpret(context, currScope, currDynScope, self2, temp);
                        if (!(instr instanceof ResultInstr)) continue block32;
                        SimpleMethodInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), result4);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ipc = instr.getRPC();
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }
}

