/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public interface BytesDecoder {
    public String decode(byte[] var1, int var2, int var3);

    public void decodeLines(byte[] var1, int var2, int var3, LineMarker var4);

    public static interface LineMarker {
        public void markLine(int var1);
    }

    public static class UTF8BytesDecoder
    implements BytesDecoder {
        @Override
        public String decode(byte[] bytes, int byteIndex, int length) {
            return new String(Arrays.copyOfRange(bytes, byteIndex, byteIndex + length), StandardCharsets.UTF_8);
        }

        @Override
        public void decodeLines(byte[] bytes, int byteIndex, int length, LineMarker lineMarker) {
            int n = byteIndex;
            while (n < byteIndex + length) {
                if (bytes[n] == 10) {
                    lineMarker.markLine(n + 1);
                }
                ++n;
            }
        }
    }
}

