/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.interop.node;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccessFactory;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.interop.node.CachedObjectAccessNode;
import com.oracle.truffle.interop.node.ForeignObjectAccessHeadNode;
import com.oracle.truffle.interop.node.GenericObjectAccessNode;
import com.oracle.truffle.interop.node.ObjectAccessNode;

class UnresolvedObjectAccessNode
extends ObjectAccessNode {
    private static final int CACHE_SIZE = 8;
    private int cacheLength = 1;

    UnresolvedObjectAccessNode() {
    }

    @Override
    public Object executeWith(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        ForeignObjectAccessHeadNode nthParent = (ForeignObjectAccessHeadNode)NodeUtil.getNthParent(this, this.cacheLength);
        ObjectAccessNode first = nthParent.getFirst();
        if (this.cacheLength < 8) {
            ++this.cacheLength;
            CachedObjectAccessNode createCachedAccess = UnresolvedObjectAccessNode.createCachedAccess(receiver, nthParent.getAccessTree(), first);
            return first.replace(createCachedAccess).executeWith(frame, receiver, arguments);
        }
        return first.replace(UnresolvedObjectAccessNode.createGenericAccess(nthParent.getAccessTree())).executeWith(frame, receiver, arguments);
    }

    private static CachedObjectAccessNode createCachedAccess(TruffleObject receiver, Message accessTree, ObjectAccessNode next) {
        ForeignAccessFactory accessFactory = receiver.getForeignAccessFactory();
        return new CachedObjectAccessNode(Truffle.getRuntime().createDirectCallNode(accessFactory.getAccess(accessTree)), next, accessFactory.getLanguageCheck());
    }

    private static GenericObjectAccessNode createGenericAccess(Message access) {
        return new GenericObjectAccessNode(access);
    }
}

