/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import com.oracle.truffle.api.utilities.ValueProfile;
import java.util.Map;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.OptionalKeywordArgMissingNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.HashOperations;

public class ReadKeywordArgumentNode
extends RubyNode {
    private final int minimum;
    private final String name;
    private final int kwIndex;
    private final ValueProfile argumentValueProfile = ValueProfile.createPrimitiveProfile();
    private final ConditionProfile optimizedProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile defaultProfile = ConditionProfile.createBinaryProfile();
    @Node.Child
    private RubyNode defaultValue;

    public ReadKeywordArgumentNode(RubyContext context, SourceSection sourceSection, int minimum, String name, RubyNode defaultValue, int kwIndex) {
        super(context, sourceSection);
        this.minimum = minimum;
        this.name = name;
        this.defaultValue = defaultValue;
        this.kwIndex = kwIndex;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.optimizedProfile.profile(RubyArguments.isKwOptimized(frame.getArguments()))) {
            Object kwarg = this.argumentValueProfile.profile(RubyArguments.getOptimizedKeywordArgument(frame.getArguments(), this.kwIndex));
            if (this.defaultProfile.profile(kwarg instanceof OptionalKeywordArgMissingNode.OptionalKeywordArgMissing)) {
                return this.defaultValue.execute(frame);
            }
            return kwarg;
        }
        DynamicObject hash = RubyArguments.getUserKeywordsHash(frame.getArguments(), this.minimum);
        if (this.defaultProfile.profile(hash == null)) {
            return this.defaultValue.execute(frame);
        }
        Object value = this.lookupKeywordInHash(hash);
        if (this.defaultProfile.profile(value == null)) {
            return this.defaultValue.execute(frame);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    private Object lookupKeywordInHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(hash)) {
            if (!keyValue.getKey().toString().equals(this.name)) continue;
            return keyValue.getValue();
        }
        return null;
    }
}

