/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.nodes.locals.WriteDeclarationVariableNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.translator.ReadNode;
import org.jruby.truffle.translator.Translator;

public class ReadDeclarationVariableNode
extends RubyNode
implements ReadNode {
    private final int frameDepth;
    @Node.Child
    private ReadFrameSlotNode readFrameSlotNode;
    public static final Set<String> ALWAYS_DEFINED_GLOBALS = new HashSet<String>(Arrays.asList("$~"));

    public ReadDeclarationVariableNode(RubyContext context, SourceSection sourceSection, int frameDepth, FrameSlot slot) {
        super(context, sourceSection);
        this.readFrameSlotNode = ReadFrameSlotNodeGen.create(slot);
        this.frameDepth = frameDepth;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.readFrameSlotNode.executeRead(RubyArguments.getDeclarationFrame(frame, this.frameDepth));
    }

    @Override
    public RubyNode makeWriteNode(RubyNode rhs) {
        return new WriteDeclarationVariableNode(this.getContext(), this.getSourceSection(), rhs, this.frameDepth, this.readFrameSlotNode.getFrameSlot());
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        if (Translator.FRAME_LOCAL_GLOBAL_VARIABLES.contains(this.readFrameSlotNode.getFrameSlot().getIdentifier())) {
            if (ALWAYS_DEFINED_GLOBALS.contains(this.readFrameSlotNode.getFrameSlot().getIdentifier()) || this.readFrameSlotNode.executeRead(RubyArguments.getDeclarationFrame(frame, this.frameDepth)) != this.nil()) {
                return this.create7BitString(StringOperations.encodeByteList("global-variable", (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.nil();
        }
        return this.create7BitString(StringOperations.encodeByteList("local-variable", (Encoding)UTF8Encoding.INSTANCE));
    }
}

