/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child")
public abstract class IsFrozenNode
extends RubyNode {
    public IsFrozenNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract boolean executeIsFrozen(Object var1);

    @Specialization
    public boolean isFrozen(boolean object) {
        return true;
    }

    @Specialization
    public boolean isFrozen(int object) {
        return true;
    }

    @Specialization
    public boolean isFrozen(long object) {
        return true;
    }

    @Specialization
    public boolean isFrozen(double object) {
        return true;
    }

    @Specialization(guards={"isNil(nil)"})
    public boolean isFrozen(Object nil) {
        return true;
    }

    @Specialization(guards={"isRubyBignum(object)"})
    public boolean isFrozenBignum(DynamicObject object) {
        return true;
    }

    @Specialization(guards={"isRubySymbol(symbol)"})
    public boolean isFrozenSymbol(DynamicObject symbol) {
        return true;
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubySymbol(object)"})
    protected boolean isFrozen(DynamicObject object, @Cached(value="createReadFrozenNode()") ReadHeadObjectFieldNode readFrozenNode) {
        try {
            return readFrozenNode.executeBoolean(object);
        }
        catch (UnexpectedResultException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected ReadHeadObjectFieldNode createReadFrozenNode() {
        return ReadHeadObjectFieldNodeGen.create(Layouts.FROZEN_IDENTIFIER, false);
    }
}

