/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

@NodeChild(value="self")
public abstract class LookupSuperMethodNode
extends RubyNode {
    @Node.Child
    MetaClassNode metaClassNode;

    public LookupSuperMethodNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
    }

    public abstract InternalMethod executeLookupSuperMethod(VirtualFrame var1, Object var2);

    @Specialization(guards={"getCurrentMethod(frame) == currentMethod", "self.getShape() == cachedShape"}, assumptions={"getUnmodifiedAssumption(selfMetaClass)"}, limit="getCacheLimit()")
    protected InternalMethod lookupSuperMethodCachedDynamicObject(VirtualFrame frame, DynamicObject self, @Cached(value="getCurrentMethod(frame)") InternalMethod currentMethod, @Cached(value="self.getShape()") Shape cachedShape, @Cached(value="metaClass(frame, self)") DynamicObject selfMetaClass, @Cached(value="doLookup(currentMethod, selfMetaClass)") InternalMethod superMethod) {
        return superMethod;
    }

    @Specialization(guards={"getCurrentMethod(frame) == currentMethod", "!isDynamicObject(self)", "self.getClass() == cachedClass"}, assumptions={"getUnmodifiedAssumption(selfMetaClass)"}, limit="getCacheLimit()")
    protected InternalMethod lookupSuperMethodCachedPrimitive(VirtualFrame frame, Object self, @Cached(value="getCurrentMethod(frame)") InternalMethod currentMethod, @Cached(value="self.getClass()") Class<?> cachedClass, @Cached(value="metaClass(frame, self)") DynamicObject selfMetaClass, @Cached(value="doLookup(currentMethod, selfMetaClass)") InternalMethod superMethod) {
        return superMethod;
    }

    @Specialization
    protected InternalMethod lookupSuperMethodUncached(VirtualFrame frame, Object self) {
        InternalMethod currentMethod = this.getCurrentMethod(frame);
        DynamicObject selfMetaClass = this.metaClass(frame, self);
        return this.doLookup(currentMethod, selfMetaClass);
    }

    public Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    protected InternalMethod getCurrentMethod(VirtualFrame frame) {
        return RubyArguments.getMethod(frame.getArguments());
    }

    protected DynamicObject metaClass(VirtualFrame frame, Object object) {
        return this.metaClassNode.executeMetaClass(frame, object);
    }

    protected InternalMethod doLookup(InternalMethod currentMethod, DynamicObject selfMetaClass) {
        assert (RubyGuards.isRubyClass(selfMetaClass));
        InternalMethod superMethod = ModuleOperations.lookupSuperMethod(currentMethod, selfMetaClass);
        if (superMethod != null && superMethod.isUndefined()) {
            superMethod = null;
        }
        return superMethod;
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().METHOD_LOOKUP_CACHE;
    }
}

