/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.om.dsl.processor;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.jruby.truffle.om.dsl.api.Layout;
import org.jruby.truffle.om.dsl.processor.layout.LayoutGenerator;
import org.jruby.truffle.om.dsl.processor.layout.LayoutParser;
import org.jruby.truffle.om.dsl.processor.layout.model.LayoutModel;

@SupportedAnnotationTypes(value={"org.jruby.truffle.om.dsl.api.Layout"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class OMProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Layout.class)) {
            assert (element.getKind() == ElementKind.INTERFACE) : element.getKind();
            this.processLayout((TypeElement)element);
        }
        return true;
    }

    private void processLayout(TypeElement layoutElement) {
        try {
            LayoutParser parser = new LayoutParser();
            parser.parse(layoutElement);
            LayoutModel layout = parser.build();
            LayoutGenerator generator = new LayoutGenerator(layout);
            JavaFileObject output = this.processingEnv.getFiler().createSourceFile(layout.getInterfaceFullName() + "Impl", layoutElement);
            try (PrintStream stream = new PrintStream(output.openOutputStream(), false, "US-ASCII");){
                generator.generate(stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void log(String file, String message) {
        try (PrintStream stream = new PrintStream((OutputStream)new FileOutputStream(file, true), false, "US-ASCII");){
            stream.println(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

