/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.StringCodeRangeableWrapper;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

public abstract class StringOperations {
    public static DynamicObject createString(RubyContext context, ByteList bytes) {
        return Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), bytes, 0, null);
    }

    public static DynamicObject create7BitString(RubyContext context, ByteList bytes) {
        return Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), bytes, 16, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static String getString(RubyContext context, DynamicObject string) {
        return Helpers.decodeByteList((Ruby)context.getRuntime(), (ByteList)StringOperations.getByteList(string));
    }

    public static StringCodeRangeableWrapper getCodeRangeable(DynamicObject string) {
        StringCodeRangeableWrapper wrapper = Layouts.STRING.getCodeRangeableWrapper(string);
        if (wrapper == null) {
            wrapper = new StringCodeRangeableWrapper(string);
            Layouts.STRING.setCodeRangeableWrapper(string, wrapper);
        }
        return wrapper;
    }

    public static int scanForCodeRange(DynamicObject string) {
        int cr = Layouts.STRING.getCodeRange(string);
        if (cr == 0) {
            CompilerDirectives.transferToInterpreter();
            cr = StringOperations.slowCodeRangeScan(string);
            Layouts.STRING.setCodeRange(string, cr);
        }
        return cr;
    }

    public static boolean isCodeRangeValid(DynamicObject string) {
        return Layouts.STRING.getCodeRange(string) == 32;
    }

    public static void clearCodeRange(DynamicObject string) {
        Layouts.STRING.setCodeRange(string, 0);
    }

    public static void keepCodeRange(DynamicObject string) {
        if (Layouts.STRING.getCodeRange(string) == 48) {
            StringOperations.clearCodeRange(string);
        }
    }

    public static void modify(DynamicObject string) {
        StringOperations.getByteList(string).invalidate();
    }

    public static void modify(DynamicObject string, int length) {
        StringOperations.getByteList(string).ensure(length);
        StringOperations.getByteList(string).invalidate();
    }

    public static void modifyAndKeepCodeRange(DynamicObject string) {
        StringOperations.modify(string);
        StringOperations.keepCodeRange(string);
    }

    @CompilerDirectives.TruffleBoundary
    public static Encoding checkEncoding(DynamicObject string, CodeRangeable other) {
        Encoding encoding = StringSupport.areCompatible((CodeRangeable)StringOperations.getCodeRangeable(string), (CodeRangeable)other);
        if (encoding == null) {
            throw Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(string)).getContext().getRuntime().newEncodingCompatibilityError(String.format("incompatible character encodings: %s and %s", StringOperations.getByteList(string).getEncoding().toString(), other.getByteList().getEncoding().toString()));
        }
        return encoding;
    }

    @CompilerDirectives.TruffleBoundary
    private static int slowCodeRangeScan(DynamicObject string) {
        ByteList byteList = StringOperations.getByteList(string);
        return StringSupport.codeRangeScan((Encoding)byteList.getEncoding(), (ByteList)byteList);
    }

    public static void forceEncoding(DynamicObject string, Encoding encoding) {
        StringOperations.modify(string);
        StringOperations.clearCodeRange(string);
        StringSupport.associateEncoding((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)encoding);
        StringOperations.clearCodeRange(string);
    }

    public static int normalizeIndex(int length, int index) {
        return ArrayOperations.normalizeIndex(length, index);
    }

    public static int clampExclusiveIndex(DynamicObject string, int index) {
        assert (RubyGuards.isRubyString(string));
        return ArrayOperations.clampExclusiveIndex(StringOperations.getByteList(string).length(), index);
    }

    @CompilerDirectives.TruffleBoundary
    public static Encoding checkEncoding(RubyContext context, DynamicObject string, CodeRangeable other, Node node) {
        Encoding encoding = StringSupport.areCompatible((CodeRangeable)StringOperations.getCodeRangeable(string), (CodeRangeable)other);
        if (encoding == null) {
            throw new RaiseException(context.getCoreLibrary().encodingCompatibilityErrorIncompatible(StringOperations.getByteList(string).getEncoding().toString(), other.getByteList().getEncoding().toString(), node));
        }
        return encoding;
    }

    public static boolean singleByteOptimizable(DynamicObject string) {
        return StringSupport.isSingleByteOptimizable((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)EncodingUtils.STR_ENC_GET((ByteListHolder)StringOperations.getCodeRangeable(string)));
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteList encodeByteList(CharSequence value, Encoding encoding) {
        return RubyString.encodeBytelist((CharSequence)value, (Encoding)encoding);
    }

    public static ByteList getByteList(DynamicObject object) {
        return Layouts.STRING.getByteList(object);
    }

    public static int commonCodeRange(int first, int second) {
        if (first == second) {
            return first;
        }
        if (first == 0 || second == 0) {
            return 0;
        }
        if (first == 48 || second == 48) {
            return 48;
        }
        return 32;
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteList createByteList(CharSequence s) {
        return ByteList.create((CharSequence)s);
    }
}

