/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.ExceptionLayout;

public class ExceptionLayoutImpl
extends BasicObjectLayoutImpl
implements ExceptionLayout {
    public static final ExceptionLayout INSTANCE = new ExceptionLayoutImpl();
    protected static final Shape.Allocator EXCEPTION_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey MESSAGE_IDENTIFIER = new HiddenKey("message");
    protected static final Property MESSAGE_PROPERTY = Property.create(MESSAGE_IDENTIFIER, EXCEPTION_ALLOCATOR.locationForType(Object.class), 0);
    protected static final HiddenKey BACKTRACE_IDENTIFIER = new HiddenKey("backtrace");
    protected static final Property BACKTRACE_PROPERTY = Property.create(BACKTRACE_IDENTIFIER, EXCEPTION_ALLOCATOR.locationForType(Backtrace.class), 0);

    protected ExceptionLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createExceptionShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new ExceptionType(logicalClass, metaClass)).addProperty(MESSAGE_PROPERTY).addProperty(BACKTRACE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createException(DynamicObjectFactory factory, Object message, Backtrace backtrace) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsException(factory));
        assert (factory.getShape().hasProperty(MESSAGE_IDENTIFIER));
        assert (factory.getShape().hasProperty(BACKTRACE_IDENTIFIER));
        return factory.newInstance(message, backtrace);
    }

    @Override
    public boolean isException(DynamicObject object) {
        return this.isException(object.getShape().getObjectType());
    }

    private boolean isException(ObjectType objectType) {
        return objectType instanceof ExceptionType;
    }

    private boolean createsException(DynamicObjectFactory factory) {
        return this.isException(factory.getShape().getObjectType());
    }

    @Override
    public Object getMessage(DynamicObject object) {
        assert (this.isException(object));
        assert (object.getShape().hasProperty(MESSAGE_IDENTIFIER));
        return MESSAGE_PROPERTY.get(object, true);
    }

    @Override
    public void setMessage(DynamicObject object, Object value) {
        assert (this.isException(object));
        assert (object.getShape().hasProperty(MESSAGE_IDENTIFIER));
        try {
            MESSAGE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Backtrace getBacktrace(DynamicObject object) {
        assert (this.isException(object));
        assert (object.getShape().hasProperty(BACKTRACE_IDENTIFIER));
        return (Backtrace)BACKTRACE_PROPERTY.get(object, true);
    }

    @Override
    public void setBacktrace(DynamicObject object, Backtrace value) {
        assert (this.isException(object));
        assert (object.getShape().hasProperty(BACKTRACE_IDENTIFIER));
        try {
            BACKTRACE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class ExceptionType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ExceptionType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ExceptionType setLogicalClass(DynamicObject logicalClass) {
            return new ExceptionType(logicalClass, this.metaClass);
        }

        @Override
        public ExceptionType setMetaClass(DynamicObject metaClass) {
            return new ExceptionType(this.logicalClass, metaClass);
        }
    }
}

