/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jruby.ast.NilNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.methods.CatchNextNode;
import org.jruby.truffle.nodes.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.nodes.methods.CatchReturnAsErrorNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.ParseEnvironment;
import org.jruby.truffle.translator.TranslatorEnvironment;

public class TranslatorDriver {
    private final ParseEnvironment parseEnvironment;

    public TranslatorDriver(RubyContext context) {
        this.parseEnvironment = new ParseEnvironment(context);
    }

    public RubyRootNode parse(RubyContext context, Source source, Encoding defaultEncoding, ParserContext parserContext, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode) {
        RootNode node;
        Parser parser = new Parser(context.getRuntime());
        StaticScope staticScope = context.getRuntime().getStaticScopeFactory().newLocalScope(null);
        if (parentFrame != null) {
            MaterializedFrame frame = parentFrame;
            while (frame != null) {
                for (FrameSlot frameSlot : frame.getFrameDescriptor().getSlots()) {
                    if (!(frameSlot.getIdentifier() instanceof String)) continue;
                    String name = (String)frameSlot.getIdentifier();
                    staticScope.addVariableThisScope(name.intern());
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
        }
        ManyVarsDynamicScope dynamicScope = new ManyVarsDynamicScope(staticScope);
        boolean isInlineSource = parserContext == ParserContext.SHELL;
        boolean bl = parserContext == ParserContext.EVAL || parserContext == ParserContext.INLINE || parserContext == ParserContext.MODULE;
        ParserConfiguration parserConfiguration = new ParserConfiguration(context.getRuntime(), 0, isInlineSource, !bl, true);
        parserConfiguration.setDefaultEncoding(defaultEncoding);
        try {
            node = (RootNode)parser.parse(source.getName(), source.getCode().getBytes(StandardCharsets.UTF_8), (DynamicScope)dynamicScope, parserConfiguration);
        }
        catch (org.jruby.exceptions.RaiseException e) {
            String message = e.getException().getMessage().asJavaString();
            if (message == null) {
                message = "(no message)";
            }
            throw new RaiseException(context.getCoreLibrary().syntaxError(message, currentNode));
        }
        return this.parse(currentNode, context, source, parserContext, parentFrame, ownScopeForAssignments, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyRootNode parse(Node currentNode, RubyContext context, Source source, ParserContext parserContext, MaterializedFrame parentFrame, boolean ownScopeForAssignments, RootNode rootNode) {
        RubyNode truffleNode;
        SourceSection sourceSection = source.createSection("<main>", 0, source.getCode().length());
        InternalMethod parentMethod = parentFrame == null ? null : RubyArguments.getMethod(parentFrame.getArguments());
        LexicalScope lexicalScope = parentMethod != null && parentMethod.getSharedMethodInfo().getLexicalScope() != null ? parentMethod.getSharedMethodInfo().getLexicalScope() : context.getRootLexicalScope();
        if (parserContext == ParserContext.MODULE) {
            Object module = RubyArguments.getSelf(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, true).getArguments());
            lexicalScope = new LexicalScope(lexicalScope, (DynamicObject)module);
        }
        this.parseEnvironment.resetLexicalScope(lexicalScope);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.parseEnvironment.getLexicalScope(), Arity.NO_ARGUMENTS, "<main>", false, null, false, false, false);
        TranslatorEnvironment environment = new TranslatorEnvironment(context, this.environmentForFrame(context, parentFrame), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), ownScopeForAssignments, false, sharedMethodInfo, sharedMethodInfo.getName(), false, null);
        Object data = this.getData(context);
        if (data != null) {
            Layouts.MODULE.getFields(context.getCoreLibrary().getObjectClass()).setConstant(context, currentNode, "DATA", data);
        }
        BodyTranslator translator = new BodyTranslator(currentNode, context, null, environment, source, parserContext == ParserContext.TOP_LEVEL);
        if (rootNode.getBodyNode() == null || rootNode.getBodyNode() instanceof NilNode) {
            translator.parentSourceSection.push(sourceSection);
            try {
                truffleNode = translator.nilNode(sourceSection);
            }
            finally {
                translator.parentSourceSection.pop();
            }
        } else {
            truffleNode = (RubyNode)rootNode.getBodyNode().accept((NodeVisitor)translator);
        }
        if (environment.getFlipFlopStates().size() > 0) {
            truffleNode = SequenceNode.sequence(context, truffleNode.getSourceSection(), translator.initFlipFlopStates(truffleNode.getSourceSection()), truffleNode);
        }
        truffleNode = new CatchNextNode(context, truffleNode.getSourceSection(), truffleNode);
        if (parserContext != ParserContext.INLINE) {
            truffleNode = new CatchReturnAsErrorNode(context, truffleNode.getSourceSection(), truffleNode);
        }
        truffleNode = new CatchRetryAsErrorNode(context, truffleNode.getSourceSection(), truffleNode);
        return new RubyRootNode(context, truffleNode.getSourceSection(), environment.getFrameDescriptor(), sharedMethodInfo, truffleNode, environment.needsDeclarationFrame());
    }

    private Object getData(RubyContext context) {
        return null;
    }

    private TranslatorEnvironment environmentForFrame(RubyContext context, MaterializedFrame frame) {
        if (frame == null) {
            return null;
        }
        NullSourceSection sourceSection = new NullSourceSection("Unknown source section", "(unknown)");
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, context.getRootLexicalScope(), Arity.NO_ARGUMENTS, "(unknown)", false, null, false, false, false);
        MaterializedFrame parent = RubyArguments.getDeclarationFrame(frame.getArguments());
        return new TranslatorEnvironment(context, this.environmentForFrame(context, parent), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, true, sharedMethodInfo, sharedMethodInfo.getName(), false, null, frame.getFrameDescriptor());
    }

    public static enum ParserContext {
        TOP_LEVEL,
        SHELL,
        MODULE,
        EVAL,
        INLINE;

    }
}

