/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class PDFontType1Tools {
    protected static PDFontDescriptorEmbedded createFontDescriptorEmbedded(PDFont pDFont) throws FontFactoryException {
        AFM aFM = PDFontType1.lookupBuiltinAFM((String)pDFont.getFontName());
        PDFontDescriptorEmbedded pDFontDescriptorEmbedded = (PDFontDescriptorEmbedded)PDFontDescriptorEmbedded.META.createNew();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (aFM != null) {
            string = aFM.getAttribute("FontBBox");
            string2 = aFM.getAttribute("ItalicAngle");
            string3 = aFM.getAttribute("Ascender");
            string4 = aFM.getAttribute("Descender");
            string5 = aFM.getAttribute("CapHeight");
            string6 = aFM.getAttribute("StdHW");
            bl = aFM.getAttribute("CharacterSet").equals("Special");
        }
        if (string == null) {
            string = "0 0 0 0";
        }
        if (string2 == null) {
            string2 = "0";
        }
        if (string3 == null) {
            string3 = "0";
        }
        if (string4 == null) {
            string4 = "0";
        }
        if (string5 == null) {
            string5 = "0";
        }
        if (string6 == null) {
            string6 = "0";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string7 = stringTokenizer.nextToken();
        String string8 = stringTokenizer.nextToken();
        String string9 = stringTokenizer.nextToken();
        String string10 = stringTokenizer.nextToken();
        pDFontDescriptorEmbedded.setFontName(pDFont.getFontName());
        pDFontDescriptorEmbedded.setFontBB(new CDSRectangle((float)Integer.valueOf(string7).intValue(), (float)Integer.valueOf(string8).intValue(), (float)Integer.valueOf(string9).intValue(), (float)Integer.valueOf(string10).intValue()));
        pDFontDescriptorEmbedded.setItalicAngle(Float.valueOf(string2).floatValue());
        pDFontDescriptorEmbedded.setAscent(Integer.valueOf(string3).intValue());
        pDFontDescriptorEmbedded.setDescent(Integer.valueOf(string4).intValue());
        pDFontDescriptorEmbedded.setCapHeight(Integer.valueOf(string5).intValue());
        pDFontDescriptorEmbedded.setStemV(Integer.valueOf(string6).intValue());
        pDFontDescriptorEmbedded.setFlags(0);
        pDFontDescriptorEmbedded.getFlags().setSymbolic(bl);
        try {
            int n = pDFont.getFirstChar();
            int n2 = pDFont.getLastChar();
            COSArray cOSArray = COSArray.create((int)(n2 - n + 1));
            IPlatformFont iPlatformFont = PlatformFontFactory.get().createPlatformFont(pDFont);
            int n3 = n;
            while (n3 <= n2) {
                PDGlyphs pDGlyphs = pDFont.getGlyphsEncoded(n3);
                IPlatformGlyphs iPlatformGlyphs = iPlatformFont.createPlatformGlyphs(pDGlyphs);
                cOSArray.add(n3 - n, (COSObject)COSInteger.create((int)iPlatformGlyphs.getWidth()));
                ++n3;
            }
            pDFont.cosSetField(PDFont.DK_Widths, (COSObject)cOSArray);
            pDFont.cosSetField(PDFont.DK_FirstChar, (COSObject)COSInteger.create((int)n));
            pDFont.cosSetField(PDFont.DK_LastChar, (COSObject)COSInteger.create((int)n2));
        }
        catch (PlatformFontException platformFontException) {
            throw new FontFactoryException(platformFontException.getMessage());
        }
        return pDFontDescriptorEmbedded;
    }

    protected static void embedFontFile(PDFont pDFont, ILocator iLocator) throws IOException {
        if (pDFont.getFontDescriptor().isBuiltin()) {
            try {
                pDFont.setFontDescriptor((PDFontDescriptor)PDFontType1Tools.createFontDescriptorEmbedded(pDFont));
            }
            catch (FontFactoryException fontFactoryException) {
                throw new IOException(fontFactoryException.getMessage());
            }
        }
        InputStream inputStream = iLocator.getInputStream();
        try {
            byte[] byArray = StreamTools.toByteArray((InputStream)inputStream);
            ((PDFontDescriptorEmbedded)pDFont.getFontDescriptor()).setFontFile(byArray);
        }
        finally {
            StreamTools.close((InputStream)inputStream);
        }
    }
}

