/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.ContentParser;
import org.icepdf.core.util.Library;

public class Form
extends Stream {
    private static final Logger logger = Logger.getLogger(Form.class.toString());
    private AffineTransform matrix = new AffineTransform();
    private Rectangle2D bbox;
    private Shapes shapes;
    private GraphicsState graphicsState;
    private Resources resources;
    private Resources parentResource;
    private boolean transparencyGroup;
    private boolean isolated;
    private boolean knockOut;
    private boolean inited = false;

    public Form(Library l, Hashtable h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h, streamInputWrapper);
        Hashtable group = this.library.getDictionary(this.entries, "Group");
        if (group != null) {
            this.transparencyGroup = true;
            this.isolated = this.library.getBoolean(group, "I");
            this.knockOut = this.library.getBoolean(group, "K");
        }
    }

    public void dispose(boolean cache) {
        if (this.shapes != null) {
            this.shapes.dispose();
        }
        if (cache) {
            this.library.removeObject(this.getPObjectReference());
        }
        this.disposeResources(cache);
    }

    public void disposeResources(boolean cache) {
        if (this.resources != null) {
            this.resources.dispose(cache, this);
        }
        if (this.parentResource != null) {
            this.parentResource = null;
        }
        this.inited = false;
        this.graphicsState = null;
        super.dispose(cache);
    }

    public void completed() {
        if (this.resources != null) {
            this.resources.removeReference(this);
            this.resources = null;
        }
        this.parentResource = null;
        this.graphicsState = null;
        this.inited = false;
    }

    public void setGraphicsState(GraphicsState graphicsState) {
        if (graphicsState != null) {
            this.graphicsState = graphicsState;
        }
    }

    private static AffineTransform getAffineTransform(Vector v) {
        float[] f = new float[6];
        for (int i = 0; i < 6; ++i) {
            f[i] = ((Number)v.elementAt(i)).floatValue();
        }
        return new AffineTransform(f);
    }

    public void setParentResources(Resources parentResource) {
        this.parentResource = parentResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.inited) {
            return;
        }
        Vector v = (Vector)this.library.getObject(this.entries, "Matrix");
        if (v != null) {
            this.matrix = Form.getAffineTransform(v);
        }
        this.bbox = this.library.getRectangle(this.entries, "BBox");
        Resources leafResources = this.library.getResources(this.entries, "Resources");
        if (leafResources != null) {
            this.resources = leafResources;
            this.resources.addReference(this);
        } else {
            leafResources = this.parentResource;
        }
        ContentParser cp = new ContentParser(this.library, leafResources);
        cp.setGraphicsState(this.graphicsState);
        InputStream in = this.getInputStreamForDecodedStreamBytes();
        if (in != null) {
            try {
                this.shapes = cp.parse(in);
            }
            catch (Throwable e) {
                this.shapes = new Shapes();
                logger.log(Level.FINE, "Error parsing Form content stream.", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        this.inited = true;
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public Rectangle2D getBBox() {
        return this.bbox;
    }

    public AffineTransform getMatrix() {
        return this.matrix;
    }

    public boolean isTransparencyGroup() {
        return this.transparencyGroup;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public boolean isKnockOut() {
        return this.knockOut;
    }
}

