/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.functions.Function_0;
import org.icepdf.core.pobjects.functions.Function_2;
import org.icepdf.core.pobjects.functions.Function_3;
import org.icepdf.core.pobjects.functions.Function_4;
import org.icepdf.core.util.Library;

public abstract class Function {
    private static final Logger logger = Logger.getLogger(Function.class.toString());
    protected float[] domain;
    protected float[] range;
    protected int functionType;

    public static Function getFunction(Library l, Object o) {
        Dictionary d = null;
        if (o instanceof Reference) {
            o = l.getObject((Reference)o);
        }
        if (o instanceof Dictionary) {
            d = (Dictionary)o;
        } else if (o instanceof Hashtable) {
            d = new Dictionary(l, (Hashtable)o);
        }
        if (d != null) {
            int fType = d.getInt("FunctionType");
            switch (fType) {
                case 0: {
                    return new Function_0(d);
                }
                case 2: {
                    return new Function_2(d);
                }
                case 3: {
                    return new Function_3(d);
                }
                case 4: {
                    return new Function_4(d);
                }
            }
        }
        return null;
    }

    protected Function(Dictionary d) {
        Vector dom = (Vector)d.getObject("Domain");
        this.domain = new float[dom.size()];
        for (int i = 0; i < dom.size(); ++i) {
            this.domain[i] = ((Number)dom.elementAt(i)).floatValue();
        }
        Vector r = (Vector)d.getObject("Range");
        if (r != null) {
            this.range = new float[r.size()];
            for (int i = 0; i < r.size(); ++i) {
                this.range[i] = ((Number)r.elementAt(i)).floatValue();
            }
        }
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public static float interpolate(float x, float xmin, float xmax, float ymin, float ymax) {
        return (x - xmin) * (ymax - ymin) / (xmax - xmin) + ymin;
    }

    public abstract float[] calculate(float[] var1);

    public float[] getDomain() {
        return this.domain;
    }

    public float[] getRange() {
        return this.range;
    }
}

