/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.tag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.icepdf.core.pobjects.Reference;

public class TaggedImage
implements Serializable {
    private Reference ref;
    private boolean inlineImage;
    private List pages;
    private List tags;

    TaggedImage(Reference ref, boolean inlineImage) {
        this.ref = ref;
        this.inlineImage = inlineImage;
        this.pages = new ArrayList(2);
        this.tags = new ArrayList(6);
    }

    public Reference getReference() {
        return this.ref;
    }

    public boolean isInlineImage() {
        return this.inlineImage;
    }

    public List getPages() {
        return this.pages;
    }

    public String describePages() {
        StringBuilder sb = new StringBuilder(32);
        int sz = this.pages.size();
        for (int i = 0; i < sz; ++i) {
            boolean oddIndex = i % 2 == 1;
            boolean closingRangeForSinglePage = false;
            if (oddIndex) {
                closingRangeForSinglePage = this.pages.get(i).equals(this.pages.get(i - 1));
                if (!closingRangeForSinglePage) {
                    sb.append('-');
                }
            } else if (i > 0) {
                sb.append(", ");
            }
            if (closingRangeForSinglePage) continue;
            sb.append(this.pages.get(i).toString());
        }
        return sb.toString();
    }

    public List getTags() {
        return this.tags;
    }

    void addPage(int pageIndex) {
        int size = this.pages.size();
        if (size == 0) {
            this.pages.add(new Integer(pageIndex));
        } else if (size % 2 == 0) {
            Integer end = (Integer)this.pages.get(size - 1);
            if (end == pageIndex - 1) {
                this.pages.set(size - 1, new Integer(pageIndex));
            } else if (end < pageIndex - 1) {
                this.pages.add(new Integer(pageIndex));
            }
        } else {
            Integer begin = (Integer)this.pages.get(size - 1);
            if (begin == pageIndex - 1) {
                this.pages.add(new Integer(pageIndex));
            } else if (begin < pageIndex - 1) {
                this.pages.add(begin);
                this.pages.add(new Integer(pageIndex));
            }
        }
    }

    void tag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    String describe() {
        StringBuilder sb = new StringBuilder(4096);
        for (String t : this.tags) {
            sb.append(t);
            sb.append("\n");
        }
        return sb.toString();
    }
}

