/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.util.CacheManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class ByteCache {
    private static final Logger logger = Logger.getLogger(ByteCache.class.toString());
    private int length = 0;
    private File tempFile = null;
    private boolean isCached = false;
    private static int fileCachingSize;
    private static int fileCachingFallbackSize;
    private static boolean isCachingEnabled;
    private FileOutputStream fileOutputStream = null;
    private FileInputStream fileInputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private CacheManager cacheManager = null;

    public ByteCache(byte[] bytes, Library library) {
        this.cacheManager = library.getCacheManager();
        try {
            int numNewBytes;
            int n = numNewBytes = bytes == null ? 0 : bytes.length;
            if (numNewBytes <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(numNewBytes);
            OutputStream out = this.getCorrectOutputStream(numNewBytes);
            out.write(bytes);
            this.length = numNewBytes;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error creating ByteCache temporary file.", e);
        }
    }

    public ByteCache(int numNewBytes, Library library) {
        this.cacheManager = library.getCacheManager();
        try {
            if (numNewBytes <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(numNewBytes);
            this.getCorrectOutputStream(numNewBytes);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error creating ByteCache temporary file.", e);
        }
    }

    public void writeBytes(InputStream in, int numNewBytes) {
        try {
            int currNumToRead;
            int totalRead;
            int currRead;
            if (numNewBytes <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(numNewBytes);
            OutputStream out = this.getCorrectOutputStream(numNewBytes);
            byte[] buffer = new byte[Math.min(numNewBytes, 4096)];
            for (totalRead = 0; totalRead < numNewBytes && (currRead = in.read(buffer, 0, currNumToRead = Math.min(buffer.length, numNewBytes - totalRead))) > 0; totalRead += currRead) {
                out.write(buffer, 0, currRead);
            }
            this.length += totalRead;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error writing to temporary file ", e);
        }
    }

    public void writeBytes(byte[] bytes, int offset, int numNewBytes) {
        try {
            if (numNewBytes <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(numNewBytes);
            OutputStream out = this.getCorrectOutputStream(Math.max(numNewBytes, 256));
            out.write(bytes, offset, numNewBytes);
            this.length += numNewBytes;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error writing to temporary file.", e);
        }
    }

    public void writeBytes(byte[] bytes) {
        try {
            int numNewBytes;
            int n = numNewBytes = bytes == null ? 0 : bytes.length;
            if (numNewBytes <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(numNewBytes);
            OutputStream out = this.getCorrectOutputStream(Math.max(numNewBytes, 256));
            out.write(bytes);
            this.length += numNewBytes;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error writing to temporary file ", e);
        }
    }

    public void writeBytes(int bytes) {
        try {
            int numNewBytes = 1;
            this.calcIfFileCachingAndPotentiallyForce(numNewBytes);
            OutputStream out = this.getCorrectOutputStream(256);
            out.write(bytes);
            this.length += numNewBytes;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error writing to temporary file ", e);
        }
    }

    public int readBytes(byte[] bytes, int offset, int length) {
        int returnValue = -1;
        try {
            InputStream in = this.getCorrectInputStream();
            if (in != null) {
                returnValue = in.read(bytes, offset, length);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error reading from temporary file ", e);
        }
        return returnValue;
    }

    public int readBytes(byte[] bytes) {
        int returnValue = -1;
        try {
            InputStream in = this.getCorrectInputStream();
            if (in != null) {
                returnValue = in.read(bytes);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error reading from temporary file ", e);
        }
        return returnValue;
    }

    public int readByte() {
        int returnValue = -1;
        try {
            InputStream in = this.getCorrectInputStream();
            if (in != null) {
                returnValue = in.read();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error reading from temporary file ", e);
        }
        return returnValue;
    }

    public void forceByteCaching() {
        if (isCachingEnabled && !this.isCached) {
            try {
                if (this.tempFile == null) {
                    this.createTempFile();
                }
                if (this.fileOutputStream == null) {
                    this.fileOutputStream = new FileOutputStream(this.tempFile);
                }
                if (this.byteArrayOutputStream != null) {
                    this.fileOutputStream.write(this.byteArrayOutputStream.toByteArray());
                }
                this.isCached = true;
                this.byteArrayOutputStream = null;
                this.byteArrayInputStream = null;
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Error creating the temp file.", e);
            }
        }
    }

    public void dispose(boolean cache) {
        try {
            if (!this.isCached && cache && this.length > fileCachingFallbackSize) {
                this.forceByteCaching();
            }
            if (this.fileOutputStream != null) {
                this.fileOutputStream.flush();
                this.fileOutputStream.close();
                this.fileOutputStream = null;
            }
            if (this.fileInputStream != null) {
                this.fileInputStream.close();
                this.fileInputStream = null;
            }
            if (this.byteArrayInputStream != null) {
                this.byteArrayInputStream.close();
                this.byteArrayInputStream = null;
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.flush();
                this.byteArrayOutputStream.close();
                if (this.isCached || !cache) {
                    this.byteArrayOutputStream = null;
                }
            }
            if (!cache) {
                this.deleteFileCache();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error closing file streams ", e);
        }
    }

    public byte[] toByteArray() {
        byte[] returnValue = null;
        try {
            if (this.isCached) {
                if (this.tempFile != null) {
                    FileInputStream fileInputStream = new FileInputStream(this.tempFile);
                    returnValue = new byte[this.length];
                    fileInputStream.read(returnValue);
                    fileInputStream.close();
                }
            } else if (this.byteArrayOutputStream != null) {
                returnValue = this.byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error reading from temporary file.", e);
        }
        return returnValue;
    }

    public void deleteFileCache() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    public void close() {
        try {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
            if (this.fileInputStream != null) {
                this.fileInputStream.close();
            }
            if (this.byteArrayInputStream != null) {
                this.byteArrayInputStream.close();
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error closing file streams.", e);
        }
    }

    public void reset() {
        try {
            if (this.byteArrayInputStream != null) {
                this.byteArrayInputStream.reset();
            }
            if (this.fileInputStream != null) {
                this.fileInputStream.close();
                this.fileInputStream = null;
                this.fileInputStream = new FileInputStream(this.tempFile);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error closing file streams.", e);
        }
    }

    public boolean isCached() {
        return this.isCached;
    }

    public int getLength() {
        return this.length;
    }

    public boolean inMemory() {
        return this.byteArrayOutputStream != null;
    }

    private void createTempFile() {
        try {
            this.tempFile = File.createTempFile("PDFByteStream" + this.getClass().hashCode(), ".tmp");
            this.tempFile.deleteOnExit();
            this.cacheManager.addCachedFile(this.tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error creating byte cache tmp file");
        }
    }

    private void calcIfFileCachingAndPotentiallyForce(int numNewBytes) {
        if (!this.isCached && this.length + numNewBytes > fileCachingSize) {
            this.forceByteCaching();
        }
    }

    private OutputStream getCorrectOutputStream(int optionalPresizing) throws IOException {
        if (this.isCached) {
            if (this.tempFile == null) {
                this.createTempFile();
            }
            if (this.fileOutputStream == null) {
                this.fileOutputStream = new FileOutputStream(this.tempFile.getAbsolutePath(), true);
            }
            return this.fileOutputStream;
        }
        if (this.byteArrayOutputStream == null) {
            this.byteArrayOutputStream = new ByteArrayOutputStream(optionalPresizing);
        }
        return this.byteArrayOutputStream;
    }

    private InputStream getCorrectInputStream() throws IOException {
        if (this.isCached) {
            if (this.tempFile != null) {
                if (this.fileInputStream == null) {
                    this.fileInputStream = new FileInputStream(this.tempFile);
                }
                return this.fileInputStream;
            }
        } else if (this.byteArrayOutputStream != null) {
            if (this.byteArrayInputStream == null) {
                this.byteArrayInputStream = new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
            }
            return this.byteArrayInputStream;
        }
        return null;
    }

    static {
        fileCachingFallbackSize = 524288;
        fileCachingSize = Defs.sysPropertyInt("org.icepdf.core.streamcache.thresholdSize", 1000000);
        if (fileCachingFallbackSize > fileCachingSize) {
            fileCachingFallbackSize = fileCachingSize;
        }
        isCachingEnabled = Defs.sysPropertyBoolean("org.icepdf.core.streamcache.enabled", true);
    }
}

