/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.views.common;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.icepdf.core.views.DocumentViewController;
import org.icepdf.core.views.DocumentViewModel;

public class ZoomHandler
implements MouseMotionListener,
MouseListener {
    private DocumentViewController documentViewController;
    private boolean isDragZoom;

    public ZoomHandler(DocumentViewController documentViewController) {
        this.documentViewController = documentViewController;
    }

    public void mouseDragged(MouseEvent e) {
        int userToolModeFlag;
        if (this.documentViewController != null && ((userToolModeFlag = this.documentViewController.getDocumentViewModel().getViewToolMode()) == 2 || userToolModeFlag == 3)) {
            this.isDragZoom = true;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x1F5) != 0 && (e.getModifiers() & 0x10) != 0) {
            int userToolModeFlag = this.documentViewController.getDocumentViewModel().getViewToolMode();
            if (userToolModeFlag == 2) {
                this.documentViewController.setZoomIn(e.getPoint());
            } else if (userToolModeFlag == 3) {
                this.documentViewController.setZoomOut(e.getPoint());
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.documentViewController != null) {
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            if (documentViewModel.isViewToolModeSelected(2)) {
                this.documentViewController.setViewCursor(3);
            } else if (documentViewModel.isViewToolModeSelected(3)) {
                this.documentViewController.setViewCursor(4);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isDragZoom) {
            this.isDragZoom = false;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

