/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import jcmdline.BooleanParam;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import jcmdline.dto.PdfFile;
import org.pdfsam.console.business.dto.Transition;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.SlideShowParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.exceptions.console.SlideShowException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class SlideShowCmdValidator
extends AbstractCmdValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        FileParam lOption;
        StringParam dtOption;
        PdfFileParam fOption;
        SlideShowParsedCommand parsedCommandDTO = new SlideShowParsedCommand();
        if (cmdLineHandler == null) throw new ConsoleException(2);
        FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
        if (!oOption.isSet()) {
            throw new ParseException(15);
        }
        File outFile = oOption.getFile();
        ValidationUtility.assertValidDirectory(outFile);
        parsedCommandDTO.setOutputFile(outFile);
        StringParam pOption = (StringParam)cmdLineHandler.getOption("p");
        if (pOption.isSet()) {
            parsedCommandDTO.setOutputFilesPrefix(pOption.getValue());
        }
        if (!(fOption = (PdfFileParam)cmdLineHandler.getOption("f")).isSet()) {
            throw new ParseException(20);
        }
        PdfFile inputFile = fOption.getPdfFile();
        ValidationUtility.assertValidPdfExtension(inputFile.getFile().getName());
        parsedCommandDTO.setInputFile(FileUtility.getPdfFile(inputFile));
        StringParam tOption = (StringParam)cmdLineHandler.getOption("t");
        if (tOption.isSet()) {
            HashSet<Transition> transitionsList = new HashSet<Transition>(tOption.getValues().size());
            Iterator tIterator = tOption.getValues().iterator();
            while (tIterator.hasNext()) {
                String transition = (String)tIterator.next();
                Transition transitionObject = this.stringToTransition(transition);
                if (transitionsList.add(transitionObject)) continue;
                throw new SlideShowException(4, new String[]{transition, transitionObject.toString()});
            }
            parsedCommandDTO.setTransitions(transitionsList.toArray(new Transition[transitionsList.size()]));
        }
        if ((dtOption = (StringParam)cmdLineHandler.getOption("dt")).isSet()) {
            parsedCommandDTO.setDefaultTransition(this.stringToTransition(dtOption.getValue()));
        }
        if ((lOption = (FileParam)cmdLineHandler.getOption("l")).isSet()) {
            if (!lOption.getFile().getPath().toLowerCase().endsWith(".xml")) throw new ParseException(22);
            parsedCommandDTO.setInputXmlFile(lOption.getFile());
        }
        parsedCommandDTO.setFullScreen(((BooleanParam)cmdLineHandler.getOption("fullscreen")).isTrue());
        return parsedCommandDTO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Transition stringToTransition(String inputString) throws ConsoleException {
        Transition retVal = null;
        if (inputString == null) throw new SlideShowException(1);
        if (inputString.length() <= 0) throw new SlideShowException(1);
        String[] transParams = inputString.split(":");
        if (transParams.length <= 2) throw new SlideShowException(2, new String[]{inputString});
        try {
            String transition = transParams[0];
            int transitionDuration = Integer.parseInt(transParams[1]);
            int duration = Integer.parseInt(transParams[2]);
            int pageNumber = transParams.length > 3 ? Integer.parseInt(transParams[3]) : 0;
            return new Transition(pageNumber, transitionDuration, transition, duration);
        }
        catch (Exception e) {
            throw new SlideShowException(3, new String[]{inputString}, e);
        }
    }
}

