/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.exceptions.console.ConsoleException;

public final class FileUtility {
    private static final Logger LOG = Logger.getLogger(FileUtility.class.getPackage().getName());
    public static final String BUFFER_NAME = "PDFsamTMPbuffer";

    private FileUtility() {
    }

    public static File generateTmpFile(String filePath) {
        LOG.debug("Creating temporary file..");
        File retVal = null;
        boolean alreadyExists = true;
        int enthropy = 0;
        String fileName = "";
        StringBuffer randomString = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            char ascii = (char)(random.nextInt(26) + 65);
            randomString.append(ascii);
        }
        while (alreadyExists) {
            fileName = BUFFER_NAME + randomString + Integer.toString(++enthropy) + ".pdf";
            File tmpFile = new File(filePath + File.separator + fileName);
            alreadyExists = tmpFile.exists();
            if (alreadyExists) continue;
            retVal = tmpFile;
        }
        return retVal;
    }

    public static File generateTmpFile(File filename) {
        File retVal = null;
        if (filename != null) {
            retVal = filename.isDirectory() ? FileUtility.generateTmpFile(filename.getPath()) : FileUtility.generateTmpFile(filename.getParent());
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void renameTemporaryFile(File tmpFile, File outputFile, boolean overwrite) throws ConsoleException {
        if (tmpFile != null && outputFile != null) {
            if (outputFile.exists()) {
                if (!overwrite) throw new ConsoleException(11, new String[]{tmpFile.getName()});
                if (!outputFile.delete()) throw new ConsoleException(10, new String[]{tmpFile.getName()});
                FileUtility.renameFile(tmpFile, outputFile);
                return;
            } else {
                FileUtility.renameFile(tmpFile, outputFile);
            }
            return;
        } else {
            LOG.error("Exception renaming temporary file, source or destination are null.");
        }
    }

    private static void renameFile(File tmpFile, File outputFile) throws ConsoleException {
        if (!tmpFile.renameTo(outputFile)) {
            throw new ConsoleException(9, new String[]{tmpFile.getName(), outputFile.getName()});
        }
    }

    public static boolean deleteFile(File tmpFile) {
        boolean retVal = false;
        try {
            if (!tmpFile.delete()) {
                LOG.error("Unable to delete file " + tmpFile.getName());
            }
        }
        catch (Exception e) {
            LOG.error("Unable to delete file " + tmpFile.getName(), e);
        }
        return retVal;
    }

    public static void copyFile(File source, File dest) {
        FileChannel in = null;
        FileChannel out = null;
        try {
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            long size = in.size();
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            out.write(buf);
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            LOG.error("Unable to copy " + source + " to " + dest);
        }
    }

    public static PdfFile getPdfFile(jcmdline.dto.PdfFile pdfFile) {
        return new PdfFile(pdfFile.getFile(), pdfFile.getPassword());
    }

    public static PdfFile[] getPdfFiles(jcmdline.dto.PdfFile[] pdfFiles) {
        ArrayList<PdfFile> retVal = new ArrayList<PdfFile>();
        for (int i = 0; i < pdfFiles.length; ++i) {
            retVal.add(new PdfFile(pdfFiles[i].getFile(), pdfFiles[i].getPassword()));
        }
        return retVal.toArray(new PdfFile[pdfFiles.length]);
    }

    public static PdfFile[] getPdfFiles(Collection pdfFiles) {
        return FileUtility.getPdfFiles(pdfFiles.toArray(new jcmdline.dto.PdfFile[pdfFiles.size()]));
    }
}

