/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.utils.perfix;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.utils.perfix.FileNameRequest;

public class PrefixParser {
    private static final int SIMPLE_PREFIX = 0;
    private static final int CURRENT_PAGE = 1;
    private static final int TIMESTAMP = 2;
    private static final int BASENAME = 4;
    private static final int FILE_NUMBER = 8;
    private static final int BOOKMARK_NAME = 16;
    private static final String PDF_EXTENSION = ".pdf";
    private static final String CURRENT_PAGE_REGX = "(.)*(\\[CURRENTPAGE(#*)\\])+(.)*";
    private static final String FILE_NUMBER_REGX = "(.)*(\\[FILENUMBER(#*)(\\d*)\\])+(.)*";
    private static final String TIMESTAMP_STRING = "[TIMESTAMP]";
    private static final String BASENAME_STRING = "[BASENAME]";
    private static final String BOOKMARK_NAME_STRING = "[BOOKMARK_NAME]";
    private static final String CURRENT_PAGE_REPLACE_REGX = "\\[CURRENTPAGE(#+)*\\]";
    private static final String FILE_NUMBER_REPLACE_REGX = "\\[FILENUMBER(#+)*(\\d+)*\\]";
    private static final String TIMESTAMP_REPLACE_RGX = "\\[TIMESTAMP\\]";
    private static final String BASENAME_REPLACE_REGX = "\\[BASENAME\\]";
    private static final String BOOKMARK_NAME_REPLACE_REGX = "\\[BOOKMARK_NAME\\]";
    private static final String INVALID_WIN_FILENAME_CHARS_REGEXP = "[\\\\/:*?\\\"<>|]";
    private String prefix = "";
    private String fileName = "";
    private int currentPrefixType = 0;

    public PrefixParser(String prefix, String fileName) throws ConsoleException {
        if (prefix != null) {
            this.prefix = prefix;
            if (prefix.indexOf(TIMESTAMP_STRING) > -1) {
                this.currentPrefixType |= 2;
            }
            if (prefix.indexOf(BASENAME_STRING) > -1) {
                this.currentPrefixType |= 4;
            }
            if (prefix.indexOf(BOOKMARK_NAME_STRING) > -1) {
                this.currentPrefixType |= 0x10;
            }
            if (prefix.matches(CURRENT_PAGE_REGX)) {
                this.currentPrefixType |= 1;
            }
            if (prefix.matches(FILE_NUMBER_REGX)) {
                this.currentPrefixType |= 8;
            }
        }
        if (fileName != null && fileName.length() > 0) {
            this.fileName = fileName.lastIndexOf(46) >= 1 ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
        } else {
            throw new ConsoleException(3);
        }
    }

    public String generateFileName(FileNameRequest request) {
        String retVal = "";
        if (request != null && !request.isEmpty()) {
            if (this.isComplexPrefix(request)) {
                retVal = this.generateSimpleFileName(true);
                if ((this.currentPrefixType & 0x10) == 16 && request.getBookmarkName() != null && request.getBookmarkName().length() > 0) {
                    retVal = this.applyBookmarkname(retVal, request.getBookmarkName());
                }
                if ((this.currentPrefixType & 1) == 1 && request.getPageNumber() != null) {
                    retVal = this.applyPagenumber(retVal, request.getPageNumber());
                }
                if ((this.currentPrefixType & 8) == 8 && request.getFileNumber() != null) {
                    retVal = this.applyFilenumber(retVal, request.getFileNumber());
                }
            } else {
                retVal = this.generateSimpleFileName(this.fileName, false);
                if (request.getPageNumber() != null) {
                    retVal = this.getFileNumberFormatter(request.getPageNumber()).format(request.getPageNumber().intValue()) + "_" + retVal;
                }
            }
        } else {
            retVal = this.generateSimpleFileName(this.fileName, this.isComplexPrefix());
        }
        return this.applyExtension(retVal);
    }

    public String generateFileName() {
        return this.generateFileName(new FileNameRequest());
    }

    private boolean isComplexPrefix(FileNameRequest request) {
        boolean retVal = false;
        retVal = (this.currentPrefixType & 0x10) == 16 && request.getBookmarkName() != null && request.getBookmarkName().length() > 0 || (this.currentPrefixType & 1) == 1 && request.getPageNumber() != null || (this.currentPrefixType & 8) == 8 && request.getFileNumber() != null || this.isComplexPrefix();
        return retVal;
    }

    private boolean isComplexPrefix() {
        return (this.currentPrefixType & 2) == 2;
    }

    private String generateSimpleFileName(String defaultPostponedName, boolean performSubstitution) {
        String retVal = this.prefix;
        if (performSubstitution) {
            if ((this.currentPrefixType & 2) == 2) {
                retVal = this.applyTimestamp(retVal);
            }
            if ((this.currentPrefixType & 4) == 4) {
                retVal = this.applyFilename(retVal, this.fileName);
            }
        } else {
            retVal = retVal + defaultPostponedName;
        }
        return retVal;
    }

    private String generateSimpleFileName(boolean performSubstitution) {
        return this.generateSimpleFileName("", performSubstitution);
    }

    private String applyExtension(String arg0) {
        String retVal = arg0;
        if (arg0 != null && !arg0.endsWith(PDF_EXTENSION)) {
            retVal = retVal + PDF_EXTENSION;
        }
        return retVal;
    }

    private String applyFilenumber(String arg0, Integer fileNumber) {
        String retVal = arg0;
        if (fileNumber != null) {
            String numberPatter = "";
            String startingValue = "";
            Matcher m = Pattern.compile(FILE_NUMBER_REGX).matcher(arg0);
            if (m.matches()) {
                numberPatter = m.group(3);
                startingValue = m.group(4);
            }
            int fileNum = 0;
            if (startingValue != null && startingValue.length() > 0) {
                fileNum = Integer.parseInt(startingValue);
            }
            String replacement = "";
            replacement = numberPatter != null && numberPatter.length() > 0 ? this.getFileNumberFormatter(numberPatter).format(fileNum) : this.getFileNumberFormatter(fileNum += fileNumber.intValue()).format(fileNum);
            retVal = arg0.replaceAll(FILE_NUMBER_REPLACE_REGX, replacement);
        }
        return retVal;
    }

    private String applyPagenumber(String arg0, Integer pageNumber) {
        String retVal = arg0;
        if (pageNumber != null) {
            String numberPatter = "";
            Matcher m = Pattern.compile(CURRENT_PAGE_REGX).matcher(arg0);
            if (m.matches()) {
                numberPatter = m.group(3);
            }
            String replacement = "";
            replacement = numberPatter != null && numberPatter.length() > 0 ? this.getFileNumberFormatter(numberPatter).format(pageNumber.intValue()) : this.getFileNumberFormatter((int)pageNumber).format(pageNumber.intValue());
            retVal = arg0.replaceAll(CURRENT_PAGE_REPLACE_REGX, replacement);
        }
        return retVal;
    }

    private String applyBookmarkname(String arg0, String bookmarkName) {
        String retVal = arg0;
        if (bookmarkName != null) {
            bookmarkName = bookmarkName.replaceAll(INVALID_WIN_FILENAME_CHARS_REGEXP, "");
            retVal = arg0.replaceAll(BOOKMARK_NAME_REPLACE_REGX, bookmarkName);
        }
        return retVal;
    }

    private String applyFilename(String arg0, String fileName) {
        String retVal = arg0;
        if (fileName != null) {
            retVal = arg0.replaceAll(BASENAME_REPLACE_REGX, fileName);
        }
        return retVal;
    }

    private String applyTimestamp(String arg0) {
        String retVal = arg0;
        String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmssSS").format(new Date());
        retVal = retVal.replaceAll(TIMESTAMP_REPLACE_RGX, timestamp);
        return retVal;
    }

    private DecimalFormat getFileNumberFormatter(Integer n) {
        DecimalFormat retVal = null;
        if (n != null) {
            retVal = this.getFileNumberFormatter((int)n);
        } else {
            retVal = new DecimalFormat();
            retVal.applyPattern("00000");
        }
        return retVal;
    }

    private DecimalFormat getFileNumberFormatter(int n) {
        DecimalFormat retVal = new DecimalFormat();
        try {
            retVal.applyPattern(Integer.toString(n).replaceAll("\\d", "0"));
        }
        catch (Exception fe) {
            retVal.applyPattern("00000");
        }
        return retVal;
    }

    private DecimalFormat getFileNumberFormatter(String arg0) {
        DecimalFormat retVal = new DecimalFormat();
        try {
            if (arg0 != null && arg0.length() > 0) {
                retVal.applyPattern(arg0.replaceAll("#", "0"));
            } else {
                retVal.applyPattern("00000");
            }
        }
        catch (Exception fe) {
            retVal.applyPattern("00000");
        }
        return retVal;
    }
}

