/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.listeners.mediators;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.GuiClient;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.gui.panels.JStatusPanel;
import org.pdfsam.guiclient.updates.UpdateManager;
import org.pdfsam.i18n.GettextResource;

public class UpdateCheckerMediator
implements ActionListener {
    private static final String DESTINATION_URL = "http://www.pdfsam.org/check-version.php";
    private static final Logger LOG = Logger.getLogger(UpdateChecker.class.getPackage().getName());
    private JStatusPanel statusPanel = null;
    private ScheduledExecutorService executor;

    public UpdateCheckerMediator(JStatusPanel statusPanel) {
        this.statusPanel = statusPanel;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkForUpdates();
    }

    public void checkForUpdates(long delay, boolean forceRecheck) {
        UpdateChecker updateChecker = new UpdateChecker(forceRecheck);
        this.executor.schedule(updateChecker, delay, TimeUnit.MILLISECONDS);
    }

    public void checkForUpdates() {
        this.checkForUpdates(0L, true);
    }

    private class UpdateChecker
    extends SwingWorker<String, Void> {
        private boolean forceRecheck = false;
        private UpdateManager updateManager = null;

        public UpdateChecker(boolean forceRecheck) {
            this.forceRecheck = forceRecheck;
            this.updateManager = new UpdateManager(String.format("%s?version=%s&remoteversion=%s&branch=%s", UpdateCheckerMediator.DESTINATION_URL, GuiClient.getVersionType(), GuiClient.getVersion(), GuiClient.getBranch()));
        }

        @Override
        protected String doInBackground() throws Exception {
            this.updateManager.checkForNewVersion(this.forceRecheck);
            if (this.updateManager.isNewVersionAvailable()) {
                LOG.info(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"New version available."));
                return this.updateManager.getAvailableVersion();
            }
            LOG.info(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"No new version available."));
            return "";
        }

        @Override
        protected void done() {
            try {
                String newVersion = (String)this.get();
                if (StringUtils.isNotBlank((String)newVersion)) {
                    UpdateCheckerMediator.this.statusPanel.setNewAvailableVersion(newVersion);
                }
            }
            catch (Exception e) {
                LOG.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), e);
            }
        }
    }
}

