/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.business.actions.AddSelectionTableAction;
import org.pdfsam.guiclient.commons.business.actions.ClearSelectionTableAction;
import org.pdfsam.guiclient.commons.business.actions.DocumentPropertiesSelectionTableAction;
import org.pdfsam.guiclient.commons.business.actions.MoveDownSelectionTableAction;
import org.pdfsam.guiclient.commons.business.actions.MoveUpSelectionTableAction;
import org.pdfsam.guiclient.commons.business.actions.ReloadDocumentSelectionTableAction;
import org.pdfsam.guiclient.commons.business.actions.RemoveSelectionTableAction;
import org.pdfsam.guiclient.commons.business.listeners.adapters.PdfSelectionMouseHeaderAdapter;
import org.pdfsam.guiclient.commons.business.listeners.adapters.TableShowPopupMouseAdapter;
import org.pdfsam.guiclient.commons.business.loaders.PdfLoader;
import org.pdfsam.guiclient.commons.components.JPdfSelectionTable;
import org.pdfsam.guiclient.commons.components.JPdfSelectionToolTipHeader;
import org.pdfsam.guiclient.commons.dnd.droppers.JPdfSelectionTableDropper;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.commons.models.SimplePdfSelectionTableModel;
import org.pdfsam.guiclient.commons.models.SortablePdfSelectionTableModel;
import org.pdfsam.guiclient.commons.renderers.ArrowHeaderRenderer;
import org.pdfsam.guiclient.commons.renderers.JPdfSelectionTableRenderer;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.i18n.GettextResource;

public class JPdfSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 7231708747828566035L;
    private static final Logger log = Logger.getLogger(JPdfSelectionPanel.class.getPackage().getName());
    public static final int UNLIMTED_SELECTABLE_FILE_NUMBER = Integer.MAX_VALUE;
    public static final int SINGLE_SELECTABLE_FILE = 1;
    public static final int DOUBLE_SELECTABLE_FILE = 2;
    public static final String OUTPUT_PATH_PROPERTY = "defaultOutputPath";
    private boolean showEveryButton = false;
    private boolean showRemoveButton = false;
    private boolean showMoveButtons = false;
    private int maxSelectableFiles = 0;
    private int showedColums;
    private final JPdfSelectionTable mainTable = new JPdfSelectionTable();
    private AbstractPdfSelectionTableModel tableModel;
    private final JList workInProgressList = new JList();
    private JScrollPane tableScrollPane;
    private JScrollPane wipListScrollPane;
    private Configuration config;
    private final JPanel buttonPanel = new JPanel();
    private final JPopupMenu popupMenu = new JPopupMenu();
    private PdfLoader loader = null;
    private DropTarget tableDropTarget;
    private DropTarget scrollPanelDropTarget;
    private final JButton addFileButton = new JButton();
    private final JButton removeFileButton = new JButton();
    private final JButton moveUpButton = new JButton();
    private final JButton moveDownButton = new JButton();
    private final JButton clearButton = new JButton();
    private boolean setOutputPathMenuItemEnabled = false;

    public JPdfSelectionPanel() {
        this(Integer.MAX_VALUE, 6, true);
    }

    public JPdfSelectionPanel(int maxSelectableFiles, int showedColums) {
        this(maxSelectableFiles, showedColums, maxSelectableFiles > 1);
    }

    public JPdfSelectionPanel(int maxSelectableFiles, int showedColums, boolean showEveryButton) {
        this(maxSelectableFiles, showedColums, showEveryButton, false, false);
    }

    public JPdfSelectionPanel(int maxSelectableFiles, int showedColums, boolean showRemoveButton, boolean showMoveButtons) {
        this(maxSelectableFiles, showedColums, false, showRemoveButton, showMoveButtons);
    }

    private JPdfSelectionPanel(int maxSelectableFiles, int showedColums, boolean showEveryButton, boolean showRemoveButton, boolean showMoveButtons) {
        this.config = Configuration.getInstance();
        this.maxSelectableFiles = maxSelectableFiles;
        this.showedColums = showedColums;
        this.showEveryButton = showEveryButton;
        this.showRemoveButton = showRemoveButton;
        this.showMoveButtons = showMoveButtons;
        this.loader = new PdfLoader(this);
        this.init();
    }

    public boolean isShowEveryButton() {
        return this.showEveryButton;
    }

    public int getMaxSelectableFiles() {
        return this.maxSelectableFiles;
    }

    public JPdfSelectionTable getMainTable() {
        return this.mainTable;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.tableModel = this.maxSelectableFiles > 1 ? new SortablePdfSelectionTableModel(this.showedColums, this.maxSelectableFiles) : new SimplePdfSelectionTableModel(this.showedColums, this.maxSelectableFiles);
        this.mainTable.setModel(this.tableModel);
        this.mainTable.setDragEnabled(true);
        this.mainTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mainTable.setRowHeight(20);
        this.mainTable.setRowMargin(5);
        this.mainTable.setAutoResizeMode(0);
        this.mainTable.setSelectionForeground(Color.BLACK);
        this.mainTable.setSelectionBackground(new Color(211, 221, 222));
        this.mainTable.getSelectionModel().setSelectionMode(1);
        this.mainTable.setGridColor(Color.LIGHT_GRAY);
        this.mainTable.setIntercellSpacing(new Dimension(3, 3));
        this.mainTable.setDefaultRenderer(String.class, new JPdfSelectionTableRenderer());
        TableColumnModel mainTableColModel = this.mainTable.getColumnModel();
        mainTableColModel.getColumn(4).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        TableColumn tc = mainTableColModel.getColumn(0);
        tc.setPreferredWidth(25);
        tc.setMaxWidth(35);
        JPdfSelectionToolTipHeader toolTipHeader = new JPdfSelectionToolTipHeader(mainTableColModel);
        toolTipHeader.setReorderingAllowed(false);
        toolTipHeader.setToolTips(this.tableModel.getToolTips());
        this.mainTable.setTableHeader(toolTipHeader);
        if (this.maxSelectableFiles > 1) {
            toolTipHeader.setDefaultRenderer(new ArrowHeaderRenderer(this.tableModel, toolTipHeader.getDefaultRenderer()));
            toolTipHeader.addMouseListener(new PdfSelectionMouseHeaderAdapter(this.tableModel));
        }
        this.tableScrollPane = new JScrollPane(this.mainTable);
        this.tableScrollPane.setHorizontalScrollBarPolicy(30);
        JPdfSelectionTableDropper dropper = new JPdfSelectionTableDropper(this.loader);
        this.tableDropTarget = new DropTarget(this.tableScrollPane, dropper);
        this.scrollPanelDropTarget = new DropTarget(this.mainTable, dropper);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.initAddButton();
        ReloadDocumentSelectionTableAction reloadAction = new ReloadDocumentSelectionTableAction(this.mainTable, this.loader);
        this.popupMenu.add(new JMenuItem(reloadAction));
        this.addToMainTableKeyBindings(reloadAction);
        DocumentPropertiesSelectionTableAction documentPropertiesAction = new DocumentPropertiesSelectionTableAction(this.mainTable);
        this.popupMenu.add(new JMenuItem(documentPropertiesAction));
        this.addToMainTableKeyBindings(documentPropertiesAction);
        if (this.showEveryButton) {
            this.initRemoveButton();
            this.initMoveUpButton();
            this.initMoveDownButton();
        } else {
            if (this.showRemoveButton) {
                this.initRemoveButton();
            }
            if (this.showMoveButtons) {
                this.initMoveUpButton();
                this.initMoveDownButton();
            }
        }
        this.initClearButton();
        this.mainTable.addMouseListener(new TableShowPopupMouseAdapter(this.popupMenu, this.mainTable));
        this.workInProgressList.setFocusable(false);
        this.workInProgressList.setModel(new DefaultListModel());
        this.workInProgressList.setBackground(this.getBackground());
        this.wipListScrollPane = new JScrollPane(this.workInProgressList);
        int wipHeight = 30;
        if (this.isSingleSelectableFile()) {
            wipHeight = 18;
        }
        this.wipListScrollPane.setMaximumSize(new Dimension(1500, wipHeight));
        this.wipListScrollPane.setPreferredSize(new Dimension(700, wipHeight));
        this.wipListScrollPane.setMinimumSize(new Dimension(300, wipHeight));
        this.wipListScrollPane.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints tableConstraints = new GridBagConstraints();
        tableConstraints.fill = 1;
        tableConstraints.gridx = 0;
        tableConstraints.gridy = 0;
        tableConstraints.gridwidth = 2;
        tableConstraints.gridheight = 2;
        tableConstraints.insets = new Insets(5, 5, 5, 5);
        tableConstraints.weightx = 1.0;
        tableConstraints.weighty = 1.0;
        this.add((Component)this.tableScrollPane, tableConstraints);
        GridBagConstraints buttonsConstraints = new GridBagConstraints();
        buttonsConstraints.fill = 1;
        buttonsConstraints.gridx = 2;
        buttonsConstraints.gridy = 0;
        buttonsConstraints.gridwidth = 1;
        buttonsConstraints.gridheight = 1;
        buttonsConstraints.insets = new Insets(5, 5, 5, 5);
        buttonsConstraints.weightx = 0.0;
        buttonsConstraints.weighty = 1.0;
        this.add((Component)this.buttonPanel, buttonsConstraints);
        GridBagConstraints wipConstraints = new GridBagConstraints();
        wipConstraints.fill = 1;
        wipConstraints.gridx = 0;
        wipConstraints.gridy = 2;
        wipConstraints.gridwidth = 3;
        wipConstraints.gridheight = 1;
        wipConstraints.insets = new Insets(1, 5, 1, 5);
        wipConstraints.weightx = 1.0;
        wipConstraints.weighty = 0.0;
        this.add((Component)this.wipListScrollPane, wipConstraints);
    }

    public synchronized void addWipText(final String wipText) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ((DefaultListModel)JPdfSelectionPanel.this.workInProgressList.getModel()).addElement(wipText);
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    public synchronized void removeWipText(final String wipText) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (!((DefaultListModel)JPdfSelectionPanel.this.workInProgressList.getModel()).removeElement(wipText)) {
                    log.debug(GettextResource.gettext((ResourceBundle)JPdfSelectionPanel.this.config.getI18nResourceBundle(), (String)"Unable to remove JList text ") + wipText);
                }
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    public synchronized void removeWipTextAll() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ((DefaultListModel)JPdfSelectionPanel.this.workInProgressList.getModel()).removeAllElements();
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    public boolean isAdding() {
        return this.loader.isExecuting();
    }

    public synchronized void addTableRow(PdfSelectionTableItem item) {
        ((AbstractPdfSelectionTableModel)this.mainTable.getModel()).addRow(item);
        log.info(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"File selected: ") + item.getInputFile().getName());
    }

    public synchronized void updateTableRow(int index, PdfSelectionTableItem item) {
        ((AbstractPdfSelectionTableModel)this.mainTable.getModel()).updateRowAt(index, item);
        log.info(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"File reloaded: ") + item.getInputFile().getName());
    }

    private void addButtonToButtonPanel(JButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setAlignmentX(0.5f);
        button.setMinimumSize(new Dimension(120, 25));
        button.setMaximumSize(new Dimension(160, 25));
        this.addEnterKeyBinding(button);
        this.buttonPanel.add(button);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    private void addEnterKeyBinding(JButton button) {
        Action action = button.getAction();
        if (action != null) {
            button.getInputMap().put(KeyStroke.getKeyStroke(10, 0), action.getValue("Name"));
            button.getActionMap().put(action.getValue("Name"), action);
        }
    }

    public PdfSelectionTableItem[] getTableRows() {
        return ((AbstractPdfSelectionTableModel)this.mainTable.getModel()).getRows();
    }

    private void addToMainTableKeyBindings(Action action) {
        Object keyStroke;
        if (action != null && (keyStroke = action.getValue("AcceleratorKey")) != null) {
            KeyStroke stroke = (KeyStroke)keyStroke;
            this.mainTable.getInputMap(1).put(stroke, action.getValue("Name"));
            this.mainTable.getActionMap().put(action.getValue("Name"), action);
        }
    }

    private void initRemoveButton() {
        RemoveSelectionTableAction removeAction = new RemoveSelectionTableAction(this.mainTable);
        this.removeFileButton.setAction(removeAction);
        this.addButtonToButtonPanel(this.removeFileButton);
        this.addToMainTableKeyBindings(removeAction);
        this.popupMenu.add(new JMenuItem(removeAction));
    }

    private void initAddButton() {
        AddSelectionTableAction addAction = new AddSelectionTableAction(this.loader, this.maxSelectableFiles == 1);
        this.addFileButton.setAction(addAction);
        this.addButtonToButtonPanel(this.addFileButton);
        this.addToMainTableKeyBindings(addAction);
    }

    private void initMoveUpButton() {
        MoveUpSelectionTableAction moveUpAction = new MoveUpSelectionTableAction(this.mainTable);
        this.moveUpButton.setAction(moveUpAction);
        this.addButtonToButtonPanel(this.moveUpButton);
        this.addToMainTableKeyBindings(moveUpAction);
        this.popupMenu.add(new JMenuItem(moveUpAction));
    }

    private void initMoveDownButton() {
        MoveDownSelectionTableAction moveDownAction = new MoveDownSelectionTableAction(this.mainTable);
        this.moveDownButton.setAction(moveDownAction);
        this.addButtonToButtonPanel(this.moveDownButton);
        this.addToMainTableKeyBindings(moveDownAction);
        this.popupMenu.add(new JMenuItem(moveDownAction));
    }

    private void initClearButton() {
        ClearSelectionTableAction clearAction = new ClearSelectionTableAction(this.mainTable);
        this.clearButton.setAction(clearAction);
        this.addButtonToButtonPanel(this.clearButton);
        this.addToMainTableKeyBindings(clearAction);
    }

    public PdfLoader getLoader() {
        return this.loader;
    }

    public JButton getAddFileButton() {
        return this.addFileButton;
    }

    public JButton getRemoveFileButton() {
        return this.removeFileButton;
    }

    public JButton getMoveUpButton() {
        return this.moveUpButton;
    }

    public JButton getMoveDownButton() {
        return this.moveDownButton;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public DropTarget getTableDropTarget() {
        return this.tableDropTarget;
    }

    public DropTarget getScrollPanelDropTarget() {
        return this.scrollPanelDropTarget;
    }

    public boolean isSetOutputPathMenuItemEnabled() {
        return this.setOutputPathMenuItemEnabled;
    }

    public boolean isSingleSelectableFile() {
        return 1 == this.maxSelectableFiles;
    }

    public void addPopupMenuAction(AbstractAction action) {
        if (action != null) {
            this.addToMainTableKeyBindings(action);
            this.popupMenu.add(new JMenuItem(action));
        }
    }

    public void setFullAccessRequired(boolean required) {
        this.mainTable.setDefaultRenderer(String.class, new JPdfSelectionTableRenderer(required));
    }

    public void clearSelectionTable() {
        ((AbstractPdfSelectionTableModel)this.getMainTable().getModel()).clearData();
    }
}

