/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.panels;

import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.WorkDoneDataModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class JStatusPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 4178557129723539075L;
    private static final Logger log = Logger.getLogger(JStatusPanel.class.getPackage().getName());
    private final JLabel plugIcon = new JLabel();
    private final JLabel updatesAvailableIcon = new JLabel();
    private final JLabel plugDesc = new JLabel();
    private final JProgressBar progressBar = new JProgressBar();
    private final Configuration config = Configuration.getInstance();
    private final String updateIconUrl = "/images/updates_available.png";

    public JStatusPanel() {
        this(null, "", 1000);
    }

    public JStatusPanel(Icon icon, String desc) {
        this(icon, desc, 1000);
    }

    public JStatusPanel(Icon icon, String desc, int maxValue) {
        this.plugIcon.setIcon(icon);
        this.updatesAvailableIcon.setIcon(new ImageIcon(this.getClass().getResource("/images/updates_available.png")));
        this.plugDesc.setText(desc);
        this.progressBar.setMaximum(maxValue);
        this.init();
    }

    public void setIcon(Icon icon) {
        this.plugIcon.setIcon(icon);
    }

    public void setText(String text) {
        this.plugDesc.setText(text);
    }

    public void setBarIndeterminate(boolean value) {
        this.progressBar.setIndeterminate(value);
    }

    public void setBarValue(int value) {
        this.progressBar.setValue(value);
    }

    public void setMaximum(int value) {
        this.progressBar.setMaximum(value);
    }

    public void setBarString(String value) {
        this.progressBar.setString(value);
    }

    public void setBarStringPainted(boolean value) {
        this.progressBar.setStringPainted(value);
    }

    public boolean isBarStringPainted() {
        return this.progressBar.isStringPainted();
    }

    public int getBarValue() {
        return this.progressBar.getValue();
    }

    public double getPercentComplete() {
        return this.progressBar.getPercentComplete();
    }

    public void setNewAvailableVersion(String version) {
        this.updatesAvailableIcon.setToolTipText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"New version available: ") + version);
        this.updatesAvailableIcon.setVisible(true);
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        this.setPreferredSize(new Dimension(600, 24));
        this.setBorder(new SoftBevelBorder(1));
        this.plugIcon.setMinimumSize(new Dimension(20, 20));
        this.updatesAvailableIcon.setMinimumSize(new Dimension(20, 20));
        this.plugDesc.setMinimumSize(new Dimension(100, 20));
        this.plugDesc.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.plugIcon.setAlignmentX(0.5f);
        this.updatesAvailableIcon.setAlignmentX(0.5f);
        this.plugDesc.setAlignmentX(0.0f);
        this.updatesAvailableIcon.setVisible(false);
        this.progressBar.setBorderPainted(true);
        this.progressBar.setOrientation(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMinimumSize(new Dimension(150, 20));
        this.progressBar.setPreferredSize(new Dimension(350, 20));
        this.progressBar.setMaximumSize(new Dimension(350, 20));
        this.progressBar.setBorder(new EtchedBorder(0));
        JSeparator separator = new JSeparator(1);
        separator.setMaximumSize(new Dimension(10, 20));
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.plugIcon);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(separator);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.plugDesc);
        this.add(Box.createHorizontalGlue());
        this.add(this.updatesAvailableIcon);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.progressBar);
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            final WorkDoneDataModel dto = (WorkDoneDataModel)arg;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    int percentage = dto.getPercentage();
                    if (percentage == -1) {
                        JStatusPanel.this.setBarIndeterminate(true);
                        JStatusPanel.this.setBarStringPainted(false);
                    } else if (percentage == 1000) {
                        JStatusPanel.this.setBarIndeterminate(false);
                        JStatusPanel.this.setBarStringPainted(true);
                        JStatusPanel.this.setBarValue(1000);
                        JStatusPanel.this.setBarString(new DecimalFormat("0.# %").format(JStatusPanel.this.getPercentComplete()));
                        if (JStatusPanel.this.config.isPlaySounds()) {
                            // empty if block
                        }
                    } else {
                        JStatusPanel.this.setBarValue(percentage);
                        JStatusPanel.this.setBarStringPainted(true);
                        JStatusPanel.this.setBarString(new DecimalFormat("0.# %").format(JStatusPanel.this.getPercentComplete()));
                    }
                }
            };
            SwingUtilities.invokeLater(runner);
        }
        catch (Exception e) {
            if (this.config.isPlaySounds()) {
                // empty if block
            }
            log.error(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), e);
        }
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

