/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.pd.DefaultAppearance;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDObject;
import java.util.ArrayList;
import java.util.List;

public abstract class PDAcroFormNode
extends PDObject {
    public static final COSName DK_Encoding = COSName.constant("Encoding");
    public static final COSName DK_DR = COSName.constant("DR");
    public static final COSName DK_Font = COSName.constant("Font");
    public static final COSName DK_DA = COSName.constant("DA");
    public static final COSName DK_Q = COSName.constant("Q");
    private CSContent defaultAppearanceContent;
    private DefaultAppearance defaultAppearance;

    public static String canonicalize(String string) {
        return string.toLowerCase();
    }

    protected PDAcroFormNode(COSObject cOSObject) {
        super(cOSObject);
    }

    public abstract void addField(PDAcroFormField var1);

    protected PDAcroFormField basicGetField(String string, boolean bl) {
        List list = this.getGenericChildren();
        if (list == null || string == null) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        for (PDAcroFormField pDAcroFormField : list) {
            PDAcroFormField pDAcroFormField2;
            String string4 = pDAcroFormField.getLocalName(bl);
            if (string2.equals(string4)) {
                if (string3 == null) {
                    return pDAcroFormField;
                }
                return pDAcroFormField.basicGetField(string3, bl);
            }
            if (string4 != null || (pDAcroFormField2 = pDAcroFormField.basicGetField(string, bl)) == null) continue;
            return pDAcroFormField2;
        }
        return null;
    }

    public List collectLeafFields() {
        return this.collectLeafFields(new ArrayList());
    }

    protected List collectLeafFields(List list) {
        for (PDAcroFormField pDAcroFormField : this.getGenericChildren()) {
            pDAcroFormField.collectLeafFields(list);
        }
        return list;
    }

    public abstract PDAcroForm getAcroForm();

    public PDAnnotation getAnnotation(int n) {
        return (PDAnnotation)this.getAnnotations().get(n);
    }

    public List getAnnotations() {
        return this.getAnnotations(new ArrayList());
    }

    protected List getAnnotations(List list) {
        for (PDAcroFormNode pDAcroFormNode : this.getGenericChildren()) {
            pDAcroFormNode.getAnnotations(list);
        }
        return list;
    }

    protected DefaultAppearance getDefaultAppearance() {
        if (this.defaultAppearance == null) {
            this.defaultAppearance = new DefaultAppearance(this);
        }
        return this.defaultAppearance;
    }

    public CSContent getDefaultAppearanceContent() {
        COSString cOSString;
        if (this.defaultAppearanceContent == null && (cOSString = this.cosGetFieldInheritable(DK_DA).asString()) != null) {
            this.defaultAppearanceContent = CSContent.createFromBytes(cOSString.byteValue());
        }
        return this.defaultAppearanceContent;
    }

    public PDFont getDefaultAppearanceFont() {
        PDFont pDFont = this.getDefaultAppearance().getFont();
        if (pDFont == null) {
            if (this.getAcroForm() != this) {
                pDFont = this.getAcroForm().getDefaultAppearanceFont();
            }
            if (pDFont == null) {
                pDFont = PDFontTools.createBuiltinFont(PDFontType1.FONT_Helvetica);
            }
        }
        return pDFont;
    }

    public float[] getDefaultAppearanceFontColor() {
        return this.getDefaultAppearance().getFontColorValues();
    }

    public COSName getDefaultAppearanceFontName() {
        return this.getDefaultAppearance().getFontName();
    }

    public float getDefaultAppearanceFontSize() {
        return this.getDefaultAppearance().getFontSize();
    }

    public PDAcroFormField getField(String string) {
        return this.getField(string, false);
    }

    public PDAcroFormField getField(String string, boolean bl) {
        String string2 = bl ? PDAcroFormNode.canonicalize(string) : string;
        return this.basicGetField(string2, bl);
    }

    public int getQuadding() {
        COSInteger cOSInteger = this.cosGetFieldInheritable(DK_Q).asInteger();
        if (cOSInteger == null) {
            return 0;
        }
        return cOSInteger.intValue();
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.defaultAppearanceContent = null;
        this.defaultAppearance = null;
    }

    public abstract boolean removeField(PDAcroFormField var1);

    protected void setDefaultAppearance(DefaultAppearance defaultAppearance) {
        this.defaultAppearance = defaultAppearance;
    }

    public void setDefaultAppearanceContent(CSContent cSContent) {
        if (cSContent != null) {
            this.cosSetField(DK_DA, COSString.create(cSContent.toByteArray()));
        } else {
            this.cosRemoveField(DK_DA);
        }
    }

    public void setDefaultAppearanceFont(PDFont pDFont) {
        this.getDefaultAppearance().setFont(pDFont);
    }

    public void setDefaultAppearanceFontColor(float[] fArray) {
        this.getDefaultAppearance().setFontColorValues(fArray);
    }

    public void setDefaultAppearanceFontSize(float f) {
        this.getDefaultAppearance().setFontSize(f);
    }

    public void setQuadding(int n) {
        this.cosSetFieldInheritable(DK_Q, COSInteger.create(n));
    }

    public static abstract class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        public Class getRootClass() {
            return PDAcroFormNode.class;
        }
    }
}

