/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.pd.PDShading;

public class PDFunctionBasedShading
extends PDShading {
    public static final COSName DK_Domain = COSName.constant("Domain");
    public static final COSName DK_Function = COSName.constant("Function");
    private static final COSName DK_Matrix = COSName.constant("Matrix");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private float[] domain;
    private PDFunction function;

    protected PDFunctionBasedShading(COSObject cOSObject) {
        super(cOSObject);
        COSArray cOSArray = (COSArray)((COSDictionary)cOSObject).get(DK_Domain);
        if (this.domain == null) {
            this.domain = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
        } else {
            this.domain = new float[4];
            int n = 0;
            while (n < 4) {
                this.domain[n] = ((COSNumber)cOSArray.get(n)).floatValue();
                ++n;
            }
        }
    }

    public float[] getDomain() {
        return this.domain;
    }

    public PDFunction getFunction() {
        if (this.function == null) {
            this.function = (PDFunction)PDFunction.META.createFromCos(((COSDictionary)this.cosGetObject()).get(DK_Function));
        }
        return this.function;
    }

    public CDSMatrix getMatrix() {
        return CDSMatrix.createFromCOS(this.cosGetField(DK_Matrix).asArray());
    }

    @Override
    public int getShadingType() {
        return 1;
    }

    public static class MetaClass
    extends PDShading.MetaClass {
        protected MetaClass(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDFunctionBasedShading(cOSObject);
        }
    }
}

