/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.StringTools;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class PasswordTools {
    private static final String CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDREFGHIJKLMNOPQRSTUVWXYZ!$%&/=?*+#-_";

    public static char[] createPassword(int n) {
        Random random = new Random(System.currentTimeMillis());
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 <= n) {
            int n3 = random.nextInt(CHARS.length());
            stringBuffer.append(CHARS.charAt(n3));
            ++n2;
        }
        return stringBuffer.toString().toCharArray();
    }

    public static String createSalt(int n) {
        byte[] byArray = ByteArrayTools.createRandomBytes(n);
        return new String(Base64.encode(byArray));
    }

    public static String hash(String string, char[] cArray) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("missing SHA-1 hash");
        }
        if (!StringTools.isEmpty(string)) {
            messageDigest.update(Base64.decode(string));
        }
        try {
            messageDigest.update(new String(cArray).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("missing UTF-8 encoding");
        }
        byte[] byArray = messageDigest.digest();
        return new String(Base64.encode(byArray));
    }
}

