/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;

public class ScopedResolver
implements IStringEvaluator {
    private List<IStringEvaluator> resolvers = new ArrayList<IStringEvaluator>();

    public void addResolver(IStringEvaluator iStringEvaluator) {
        this.resolvers.add(iStringEvaluator);
    }

    @Override
    public Object evaluate(String string, IArgs iArgs) throws EvaluationException {
        for (IStringEvaluator iStringEvaluator : this.resolvers) {
            try {
                return iStringEvaluator.evaluate(string, iArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new EvaluationException("can't evaluate '" + string + "'");
    }

    public IStringEvaluator popResolver() {
        if (this.resolvers.size() == 0) {
            return null;
        }
        return this.resolvers.remove(0);
    }

    public void pushResolver(IStringEvaluator iStringEvaluator) {
        this.resolvers.add(0, iStringEvaluator);
    }

    public void removeResolver(IStringEvaluator iStringEvaluator) {
        this.resolvers.remove(iStringEvaluator);
    }
}

