/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Declaration;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;

public class DeclarationBlock
extends Declaration
implements IDeclarationBlock {
    private IDeclarationElement[] declarations;

    public DeclarationBlock(Object object) {
        super(object);
        this.declarations = new IDeclarationElement[0];
    }

    public DeclarationBlock(Object object, IDeclarationElement[] iDeclarationElementArray) {
        super(object);
        if (iDeclarationElementArray == null) {
            throw new IllegalArgumentException("declarations can't be null");
        }
        this.declarations = iDeclarationElementArray;
    }

    @Override
    public void addDeclarationElement(IDeclarationElement iDeclarationElement) {
        int n = 0;
        while (n < this.declarations.length) {
            IDeclarationElement iDeclarationElement2 = this.declarations[n];
            if (iDeclarationElement2.getName().equals(iDeclarationElement.getName())) {
                this.declarations[n] = iDeclarationElement;
                return;
            }
            ++n;
        }
        IDeclarationElement[] iDeclarationElementArray = new IDeclarationElement[this.declarations.length + 1];
        System.arraycopy(this.declarations, 0, iDeclarationElementArray, 0, this.declarations.length);
        iDeclarationElementArray[this.declarations.length] = iDeclarationElement;
        this.declarations = iDeclarationElementArray;
    }

    @Override
    public void clear() {
        if (this.declarations.length == 0) {
            return;
        }
        this.declarations = new IDeclarationElement[0];
    }

    @Override
    public IDeclaration copy() {
        IDeclarationElement[] iDeclarationElementArray = new IDeclarationElement[this.size()];
        int n = 0;
        while (n < this.declarations.length) {
            IDeclarationElement iDeclarationElement = this.declarations[n];
            iDeclarationElementArray[n] = (IDeclarationElement)iDeclarationElement.copy();
            ++n;
        }
        return new DeclarationBlock(this.getDeclarationContext(), iDeclarationElementArray);
    }

    @Override
    public IDeclarationElement getDeclarationElement(String string) {
        int n = 0;
        while (n < this.declarations.length) {
            IDeclarationElement iDeclarationElement = this.declarations[n];
            if (iDeclarationElement.getName().equals(string)) {
                return iDeclarationElement;
            }
            ++n;
        }
        return null;
    }

    @Override
    public IDeclarationElement[] getDeclarationElements() {
        return this.declarations;
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    @Override
    public void moveDown(IDeclarationElement iDeclarationElement) {
        int n = 0;
        while (n < this.declarations.length - 1) {
            if (this.declarations[n] == iDeclarationElement) {
                this.declarations[n] = this.declarations[n + 1];
                this.declarations[n + 1] = iDeclarationElement;
                break;
            }
            ++n;
        }
    }

    @Override
    public void moveUp(IDeclarationElement iDeclarationElement) {
        int n = 1;
        while (n < this.declarations.length) {
            if (this.declarations[n] == iDeclarationElement) {
                this.declarations[n] = this.declarations[n - 1];
                this.declarations[n - 1] = iDeclarationElement;
                break;
            }
            ++n;
        }
    }

    @Override
    public boolean removeDeclarationElement(IDeclarationElement iDeclarationElement) {
        int n = 0;
        while (n < this.declarations.length) {
            if (this.declarations[n] == iDeclarationElement) {
                IDeclarationElement[] iDeclarationElementArray = new IDeclarationElement[this.declarations.length - 1];
                System.arraycopy(this.declarations, 0, iDeclarationElementArray, 0, n);
                System.arraycopy(this.declarations, n + 1, iDeclarationElementArray, n, this.declarations.length - n - 1);
                this.declarations = iDeclarationElementArray;
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public int size() {
        return this.declarations.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        IDeclarationElement[] iDeclarationElementArray = this.declarations;
        int n = this.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IDeclarationElement iDeclarationElement = iDeclarationElementArray[n2];
            stringBuilder.append(iDeclarationElement.toString());
            stringBuilder.append("\n");
            ++n2;
        }
        return stringBuilder.toString();
    }
}

